"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedFailure = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _interpreter = require("@kbn/interpreter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/advanced_failure.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getApplyButtonLabel: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.applyButtonLabel', {
    defaultMessage: 'Apply'
  }),
  getResetButtonLabel: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.resetButtonLabel', {
    defaultMessage: 'Reset'
  }),
  getRowErrorMessage: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.rowErrorMessage', {
    defaultMessage: 'Invalid Expression'
  })
};
const isValid = argExpression => {
  try {
    (0, _interpreter.fromExpression)(argExpression, 'argument');
    return true;
  } catch (e) {
    return false;
  }
};
const AdvancedFailure = props => {
  const {
    onValueChange,
    defaultValue,
    argValue,
    resetErrorState,
    argId
  } = props;
  const [argExpression, setArgExpression] = (0, _react.useState)((0, _interpreter.toExpression)(argValue, 'argument'));
  const [valid, setValid] = (0, _react.useState)(isValid(argExpression));
  (0, _react.useEffect)(() => {
    const argExpr = (0, _interpreter.toExpression)(argValue, 'argument');
    setArgExpression(argExpr);
    setValid(isValid(argExpr));
  }, [argValue]);
  const valueChange = ev => {
    ev.preventDefault();
    resetErrorState(); // when setting a new value, attempt to reset the error state
    if (valid) {
      return onValueChange((0, _interpreter.fromExpression)(argExpression.trim(), 'argument'));
    }
  };
  const confirmReset = ev => {
    ev.preventDefault();
    resetErrorState(); // when setting a new value, attempt to reset the error state
    onValueChange((0, _interpreter.fromExpression)(defaultValue, 'argument'));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    id: argId,
    isInvalid: !valid,
    error: strings.getRowErrorMessage(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    id: argId,
    isInvalid: !valid,
    value: argExpression,
    compressed: true,
    onChange: ev => setArgExpression(ev.target.value),
    rows: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !valid,
    onClick: e => valueChange(e),
    size: "s",
    type: "submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, strings.getApplyButtonLabel()), defaultValue && defaultValue.length && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "danger",
    onClick: confirmReset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, strings.getResetButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
};
exports.AdvancedFailure = AdvancedFailure;
AdvancedFailure.propTypes = {
  defaultValue: _propTypes.default.string,
  onValueChange: _propTypes.default.func.isRequired,
  resetErrorState: _propTypes.default.func.isRequired,
  argId: _propTypes.default.string.isRequired,
  argValue: _propTypes.default.any.isRequired
};