"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceInstanceContainerMetadata = void 0;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _apm = require("../../../common/es_fields/apm");
var _maybe2 = require("../../../common/utils/maybe");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getServiceInstanceContainerMetadata = async ({
  infraMetricsClient,
  containerId,
  start,
  end
}) => {
  var _maybe;
  const should = [{
    exists: {
      field: _apm.KUBERNETES
    }
  }, {
    exists: {
      field: _apm.CONTAINER_IMAGE
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_CONTAINER_NAME
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_NAMESPACE
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_POD_NAME
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_POD_UID
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_REPLICASET_NAME
    }
  }, {
    exists: {
      field: _apm.KUBERNETES_DEPLOYMENT_NAME
    }
  }];
  const fields = (0, _as_mutable_array.asMutableArray)([_apm.KUBERNETES_POD_NAME, _apm.KUBERNETES_POD_UID, _apm.KUBERNETES_DEPLOYMENT_NAME, _apm.KUBERNETES_CONTAINER_ID, _apm.KUBERNETES_CONTAINER_NAME, _apm.KUBERNETES_NAMESPACE, _apm.KUBERNETES_REPLICASET_NAME, _apm.KUBERNETES_DEPLOYMENT_NAME]);
  const response = await infraMetricsClient.search({
    size: 1,
    track_total_hits: false,
    fields,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.CONTAINER_ID]: containerId
          }
        }, ...(0, _server.rangeQuery)(start, end)],
        should
      }
    }
  });
  const hits = (_maybe = (0, _maybe2.maybe)(response.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields;
  const sample = hits && (0, _utils.accessKnownApmEventFields)(hits);
  return {
    kubernetes: {
      pod: {
        name: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_POD_NAME],
        uid: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_POD_UID]
      },
      deployment: {
        name: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_DEPLOYMENT_NAME]
      },
      replicaset: {
        name: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_REPLICASET_NAME]
      },
      namespace: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_NAMESPACE],
      container: {
        name: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_CONTAINER_NAME],
        id: sample === null || sample === void 0 ? void 0 : sample[_apm.KUBERNETES_CONTAINER_ID]
      }
    }
  };
};
exports.getServiceInstanceContainerMetadata = getServiceInstanceContainerMetadata;