"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetadataForDependency = getMetadataForDependency;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _maybe2 = require("../../../common/utils/maybe");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMetadataForDependency({
  apmEventClient,
  dependencyName,
  start,
  end
}) {
  var _maybe;
  const fields = (0, _as_mutable_array.asMutableArray)([_apm.SPAN_TYPE, _apm.SPAN_SUBTYPE]);
  const sampleResponse = await apmEventClient.search('get_metadata_for_dependency', {
    apm: {
      events: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 1,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.SPAN_DESTINATION_SERVICE_RESOURCE]: dependencyName
          }
        }, ...(0, _server.rangeQuery)(start, end)]
      }
    },
    fields,
    sort: {
      '@timestamp': 'desc'
    }
  });
  const hitFields = (_maybe = (0, _maybe2.maybe)(sampleResponse.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields;
  const sample = hitFields && (0, _utils.accessKnownApmEventFields)(hitFields);
  return {
    spanType: sample === null || sample === void 0 ? void 0 : sample[_apm.SPAN_TYPE],
    spanSubtype: sample === null || sample === void 0 ? void 0 : sample[_apm.SPAN_SUBTYPE]
  };
}