"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNameFromSignals = getServiceNameFromSignals;
var _queries = require("@kbn/observability-plugin/server/utils/queries");
var _moment = _interopRequireDefault(require("moment"));
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apmTypes = require("@kbn/apm-types");
var _maybe2 = require("../../../../common/utils/maybe");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceNameFromSignals({
  query,
  esClient,
  logSourcesService,
  apmEventClient
}) {
  if (query['service.name']) {
    return query['service.name'];
  }
  if (!query['kubernetes.pod.name'] && !query['container.id']) {
    return;
  }
  const start = (0, _moment.default)(query.alert_started_at).subtract(30, 'minutes').valueOf();
  const end = (0, _moment.default)(query.alert_started_at).valueOf();
  const params = {
    _source: ['service.name'],
    terminate_after: 1,
    size: 1,
    track_total_hits: false,
    query: {
      bool: {
        filter: [{
          bool: {
            should: [...(0, _queries.termQuery)('container.id', query['container.id']), ...(0, _queries.termQuery)('kubernetes.pod.name', query['kubernetes.pod.name'])],
            minimum_should_match: 1
          }
        }, {
          exists: {
            field: 'service.name'
          }
        }, ...(0, _queries.rangeQuery)(start, end)]
      }
    }
  };
  const serviceName = await getServiceNameFromTraces({
    params,
    apmEventClient
  });
  if (serviceName) {
    return serviceName;
  }
  return getServiceNameFromLogs({
    params,
    esClient,
    logSourcesService
  });
}
async function getServiceNameFromLogs({
  params,
  esClient,
  logSourcesService
}) {
  var _res$hits$hits$, _res$hits$hits$$_sour, _res$hits$hits$$_sour2;
  const index = await logSourcesService.getFlattenedLogSources();
  const res = await (0, _queries.typedSearch)(esClient, {
    index,
    ...params
  });
  return (_res$hits$hits$ = res.hits.hits[0]) === null || _res$hits$hits$ === void 0 ? void 0 : (_res$hits$hits$$_sour = _res$hits$hits$._source) === null || _res$hits$hits$$_sour === void 0 ? void 0 : (_res$hits$hits$$_sour2 = _res$hits$hits$$_sour.service) === null || _res$hits$hits$$_sour2 === void 0 ? void 0 : _res$hits$hits$$_sour2.name;
}
async function getServiceNameFromTraces({
  params,
  apmEventClient
}) {
  var _maybe;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SERVICE_NAME]);
  const res = await apmEventClient.search('get_service_name_from_traces', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    ...params,
    fields: requiredFields
  });
  const fields = (_maybe = (0, _maybe2.maybe)(res.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields;
  const event = fields && (0, _utils.accessKnownApmEventFields)(fields).requireFields(requiredFields);
  return event === null || event === void 0 ? void 0 : event[_apmTypes.SERVICE_NAME];
}