"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _server = require("@kbn/rule-registry-plugin/server");
var _lodash = require("lodash");
var _ = require(".");
var _tutorials = require("../common/tutorial/tutorials");
var _assistant_functions = require("./assistant_functions");
var _deprecations = require("./deprecations");
var _feature = require("./feature");
var _apm_telemetry = require("./lib/apm_telemetry");
var _get_internal_saved_objects_client = require("./lib/helpers/get_internal_saved_objects_client");
var _register_apm_rule_types = require("./routes/alerts/register_apm_rule_types");
var _get_global_apm_server_route_repository = require("./routes/apm_routes/get_global_apm_server_route_repository");
var _register_apm_server_routes = require("./routes/apm_routes/register_apm_server_routes");
var _get_observability_alert_details_context = require("./routes/assistant_functions/get_observability_alert_details_context");
var _add_api_keys_to_policies_if_missing = require("./routes/fleet/api_keys/add_api_keys_to_policies_if_missing");
var _register_fleet_policy_callbacks = require("./routes/fleet/register_fleet_policy_callbacks");
var _create_agent_config_index = require("./routes/settings/agent_configuration/create_agent_config_index");
var _create_custom_link_index = require("./routes/settings/custom_link/create_custom_link_index");
var _create_apm_source_map_index_template = require("./routes/source_maps/create_apm_source_map_index_template");
var _schedule_source_map_migration = require("./routes/source_maps/schedule_source_map_migration");
var _saved_objects = require("./saved_objects");
var _tutorial = require("./tutorial");
var _tools = require("./agent_builder/tools");
var _register_data_providers = require("./agent_builder/data_provider/register_data_providers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class APMPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "currentConfig", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
  }
  setup(core, plugins) {
    var _resourcePlugins$usag, _plugins$observabilit;
    const logger = this.logger = this.initContext.logger.get();
    const config$ = this.initContext.config.create();
    core.savedObjects.registerType(_saved_objects.apmTelemetry);
    core.savedObjects.registerType(_saved_objects.apmServerSettings);
    core.savedObjects.registerType(_saved_objects.apmServiceGroups);
    core.savedObjects.registerType(_saved_objects.apmCustomDashboards);
    const currentConfig = this.initContext.config.get();
    this.currentConfig = currentConfig;
    if (plugins.taskManager && plugins.usageCollection && currentConfig.telemetryCollectionEnabled) {
      (0, _apm_telemetry.createApmTelemetry)({
        core,
        getApmIndices: plugins.apmDataAccess.getApmIndices,
        usageCollector: plugins.usageCollection,
        taskManager: plugins.taskManager,
        logger: this.logger,
        kibanaVersion: this.initContext.env.packageInfo.version,
        isProd: this.initContext.env.mode.prod
      }).catch(() => {});
    }
    plugins.features.registerKibanaFeature(_feature.APM_FEATURE);
    (0, _feature.registerFeaturesUsage)({
      licensingPlugin: plugins.licensing
    });
    const getCoreStart = () => core.getStartServices().then(([coreStart]) => coreStart);
    const getPluginStart = () => core.getStartServices().then(([coreStart, pluginStart]) => pluginStart);
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    const ruleDataClient = ruleDataService.initializeIndex({
      feature: _.APM_SERVER_FEATURE_ID,
      registrationContext: _register_apm_rule_types.APM_RULE_TYPE_ALERT_CONTEXT,
      dataset: _server.Dataset.alerts,
      componentTemplateRefs: [],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common.mappingFromFieldMap)(_register_apm_rule_types.apmRuleTypeAlertFieldMap, 'strict')
      }]
    });
    const resourcePlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const apmIndicesPromise = (async () => {
      const coreStart = await getCoreStart();
      const soClient = await (0, _get_internal_saved_objects_client.getInternalSavedObjectsClient)(coreStart);
      const {
        getApmIndices
      } = plugins.apmDataAccess;
      return getApmIndices(soClient);
    })();
    const managedOtlpServiceFeaturePromise = (async () => {
      const coreStart = await getCoreStart();
      return await coreStart.featureFlags.getBooleanValue('observability.managedOtlpServiceEnabled', false);
    })();

    // This if else block will go away in favour of removing Home Tutorial Integration
    // Ideally we will directly register a custom integration and pass the configs
    // for cloud, onPrem and Serverless so that the actual component can take
    // care of rendering
    if (currentConfig.serverlessOnboarding && plugins.customIntegrations) {
      var _plugins$customIntegr;
      (_plugins$customIntegr = plugins.customIntegrations) === null || _plugins$customIntegr === void 0 ? void 0 : _plugins$customIntegr.registerCustomIntegration(_tutorials.apmTutorialCustomIntegration);
    } else {
      Promise.all([apmIndicesPromise, managedOtlpServiceFeaturePromise]).then(([apmIndices, isManagedOtlpServiceFeatureEnabled]) => {
        var _plugins$home;
        (_plugins$home = plugins.home) === null || _plugins$home === void 0 ? void 0 : _plugins$home.tutorials.registerTutorial((0, _tutorial.tutorialProvider)({
          apmConfig: currentConfig,
          apmIndices,
          cloud: plugins.cloud,
          observability: plugins.observability,
          isFleetPluginEnabled: !(0, _lodash.isEmpty)(resourcePlugins.fleet),
          isManagedOtlpServiceFeatureEnabled,
          managedOtlpServiceUrl: plugins.observability.managedOtlpServiceUrl
        }));
      }).catch(() => {});
    }
    const telemetryUsageCounter = (_resourcePlugins$usag = resourcePlugins.usageCollection) === null || _resourcePlugins$usag === void 0 ? void 0 : _resourcePlugins$usag.setup.createUsageCounter(_.APM_SERVER_FEATURE_ID);
    const kibanaVersion = this.initContext.env.packageInfo.version;
    (0, _register_apm_server_routes.registerRoutes)({
      core: {
        setup: core,
        start: getCoreStart
      },
      logger: this.logger,
      config: currentConfig,
      featureFlags: currentConfig.featureFlags,
      repository: (0, _get_global_apm_server_route_repository.getGlobalApmServerRouteRepository)(),
      ruleDataClient,
      plugins: resourcePlugins,
      telemetryUsageCounter,
      kibanaVersion
    });
    const {
      getApmIndices
    } = plugins.apmDataAccess;
    if (plugins.alerting) {
      (0, _register_apm_rule_types.registerApmRuleTypes)({
        getApmIndices,
        alerting: plugins.alerting,
        basePath: core.http.basePath,
        apmConfig: currentConfig,
        logger: this.logger.get('rule'),
        ml: plugins.ml,
        observability: plugins.observability,
        ruleDataClient,
        alertsLocator: plugins.share.url.locators.get(_common2.alertsLocatorID)
      });
    }
    (0, _register_fleet_policy_callbacks.registerFleetPolicyCallbacks)({
      logger: this.logger,
      coreStartPromise: getCoreStart(),
      plugins: resourcePlugins
    }).catch(e => {
      var _this$logger, _this$logger2;
      (_this$logger = this.logger) === null || _this$logger === void 0 ? void 0 : _this$logger.error('Failed to register APM Fleet policy callbacks');
      (_this$logger2 = this.logger) === null || _this$logger2 === void 0 ? void 0 : _this$logger2.error(e);
    });

    // This will add an API key to all existing APM package policies
    (0, _add_api_keys_to_policies_if_missing.addApiKeysToEveryPackagePolicyIfMissing)({
      coreStartPromise: getCoreStart(),
      licensing: plugins.licensing,
      pluginStartPromise: getPluginStart(),
      logger: this.logger
    }).catch(e => {
      var _this$logger3, _this$logger4;
      (_this$logger3 = this.logger) === null || _this$logger3 === void 0 ? void 0 : _this$logger3.error('Failed to add API keys to APM package policies');
      (_this$logger4 = this.logger) === null || _this$logger4 === void 0 ? void 0 : _this$logger4.error(e);
    });
    const taskManager = plugins.taskManager;

    // create source map index and run migrations
    (0, _schedule_source_map_migration.scheduleSourceMapMigration)({
      coreStartPromise: getCoreStart(),
      pluginStartPromise: getPluginStart(),
      taskManager,
      logger: this.logger
    }).catch(e => {
      var _this$logger5, _this$logger6;
      (_this$logger5 = this.logger) === null || _this$logger5 === void 0 ? void 0 : _this$logger5.error('Failed to schedule APM source map migration');
      (_this$logger6 = this.logger) === null || _this$logger6 === void 0 ? void 0 : _this$logger6.error(e);
    });
    (_plugins$observabilit = plugins.observabilityAIAssistant) === null || _plugins$observabilit === void 0 ? void 0 : _plugins$observabilit.service.register((0, _assistant_functions.registerAssistantFunctions)({
      config: this.currentConfig,
      coreSetup: core,
      featureFlags: this.currentConfig.featureFlags,
      kibanaVersion,
      logger: this.logger.get('assistant'),
      plugins: resourcePlugins,
      ruleDataClient
    }));
    plugins.observability.alertDetailsContextualInsightsService.registerHandler((0, _get_observability_alert_details_context.getAlertDetailsContextHandler)(getCoreStart(), resourcePlugins, logger));
    if (plugins.onechat) {
      var _this$logger9;
      (0, _tools.registerAgentTools)({
        core,
        plugins,
        logger: this.logger.get('observabilityAgent')
      }).catch(e => {
        var _this$logger7, _this$logger8;
        (_this$logger7 = this.logger) === null || _this$logger7 === void 0 ? void 0 : _this$logger7.error(`Failed to register observability agent APM tools: ${e.message}`);
        (_this$logger8 = this.logger) === null || _this$logger8 === void 0 ? void 0 : _this$logger8.debug(e);
      });
      (_this$logger9 = this.logger) === null || _this$logger9 === void 0 ? void 0 : _this$logger9.debug('Successfully registered observability agent APM tools');
    }
    (0, _register_data_providers.registerDataProviders)({
      core,
      plugins,
      logger: this.logger.get('observabilityAgent')
    });
    (0, _deprecations.registerDeprecations)({
      core,
      apmDeps: {
        logger: this.logger,
        security: plugins.security
      }
    });
    return {
      config$
    };
  }
  start(core, plugins) {
    if (this.currentConfig == null || this.logger == null) {
      throw new Error('APMPlugin needs to be setup before calling start()');
    }
    const logger = this.logger;
    const client = core.elasticsearch.client.asInternalUser;

    // create .apm-agent-configuration index without blocking start lifecycle
    (0, _create_agent_config_index.createApmAgentConfigurationIndex)({
      client,
      logger
    }).catch(e => {
      logger.debug(`Failed to create .apm-agent-configuration index: ${e.message}`);
    });

    // create .apm-custom-link index without blocking start lifecycle
    (0, _create_custom_link_index.createApmCustomLinkIndex)({
      client,
      logger
    }).catch(e => {
      logger.debug(`Failed to create .apm-custom-link index: ${e.message}`);
    });

    // create .apm-source-map index without blocking start lifecycle
    (0, _create_apm_source_map_index_template.createApmSourceMapIndexTemplate)({
      client,
      logger
    }).catch(e => {
      logger.debug(`Failed to create apm-source-map index template: ${e.message}`);
    });
  }
  stop() {}
}
exports.APMPlugin = APMPlugin;