"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmToolAvailability = getApmToolAvailability;
var _feature_flag = require("../../../common/agent_builder/feature_flag");
var _has_historical_agent_data = require("../../routes/historical_data/has_historical_agent_data");
var _get_is_obs_agent_enabled = require("./get_is_obs_agent_enabled");
var _build_apm_tool_resources = require("./build_apm_tool_resources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmToolAvailability({
  core,
  plugins,
  request,
  logger
}) {
  try {
    const isEnabled = await (0, _get_is_obs_agent_enabled.getIsObservabilityAgentEnabled)(core);
    if (!isEnabled) {
      return {
        status: 'unavailable',
        reason: `Feature flag "${_feature_flag.OBSERVABILITY_AGENT_FEATURE_FLAG}" is disabled`
      };
    }
    const {
      apmEventClient
    } = await (0, _build_apm_tool_resources.buildApmToolResources)({
      core,
      plugins,
      request,
      logger
    });
    const hasHistoricalData = await (0, _has_historical_agent_data.hasHistoricalAgentData)(apmEventClient);
    logger.debug(`Has historical APM data: ${hasHistoricalData}`);
    return hasHistoricalData ? {
      status: 'available'
    } : {
      status: 'unavailable',
      reason: 'No historical APM data'
    };
  } catch (error) {
    logger.error(`Failed to check observability agent availability: ${error === null || error === void 0 ? void 0 : error.message}`);
    logger.debug(error);
    return {
      status: 'unavailable',
      reason: 'Failed observability agent availability check'
    };
  }
}