"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigInstructions = AgentConfigInstructions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _opentelemetry_instructions = require("./opentelemetry_instructions");
var _get_apm_agent_commands = require("./commands/get_apm_agent_commands");
var _agent_config_table = require("./agent_config_table");
var _commands_instructions_codeblock = require("./commands_instructions_codeblock");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/config_agent/agent_config_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SECRET_TOKEN_COMMAND_PLACEHOLDER = '<SECRET_TOKEN>';
function AgentConfigInstructions({
  variantId,
  apmServerUrl,
  secretToken
}) {
  const defaultValues = {
    apmServiceName: 'my-service-name',
    apmEnvironment: 'my-environment'
  };
  if (variantId === 'openTelemetry') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_opentelemetry_instructions.OpenTelemetryInstructions, {
      apmServerUrl: apmServerUrl,
      secretToken: secretToken,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }));
  }
  const commands = (0, _get_apm_agent_commands.getApmAgentCommands)({
    variantId,
    policyDetails: {
      apmServerUrl,
      secretToken: `${SECRET_TOKEN_COMMAND_PLACEHOLDER}`
    },
    defaultValues
  });
  const commandsWithSecrets = (0, _get_apm_agent_commands.getApmAgentCommands)({
    variantId,
    policyDetails: {
      apmServerUrl,
      secretToken
    },
    defaultValues
  });
  const variables = (0, _get_apm_agent_commands.getApmAgentVariables)(variantId);
  const lineNumbers = (0, _get_apm_agent_commands.getApmAgentLineNumbers)(variantId);
  const highlightLang = (0, _get_apm_agent_commands.getApmAgentHighlightLang)(variantId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_config_table.AgentConfigurationTable, {
    variables: variables,
    data: {
      apmServerUrl,
      secretToken,
      ...defaultValues
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_commands_instructions_codeblock.CommandsInstructionsCodeblock, {
    variantId: variantId,
    lineNumbers: lineNumbers,
    highlightLang: highlightLang,
    commands: commands,
    commandsWithSecrets: commandsWithSecrets,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
}