"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentSelect = EnvironmentSelect;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_environment_select = require("./use_environment_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/environment_select/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getEnvironmentOptions(environments) {
  const environmentOptions = environments.filter(env => env !== _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value).map(environment => ({
    value: environment,
    label: environment
  }));
  return [_environment_filter_values.ENVIRONMENT_ALL, ...(environments.includes(_environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) ? [_environment_filter_values.ENVIRONMENT_NOT_DEFINED] : []), ...environmentOptions];
}
function shouldFetch({
  newValue,
  oldValue,
  optionList
}) {
  return newValue !== '' && (!optionList.some(option => option.toLowerCase().includes(newValue.toLowerCase())) || !newValue.toLowerCase().includes(oldValue.toLowerCase()));
}
function EnvironmentSelect({
  environment,
  availableEnvironments,
  status,
  serviceName,
  rangeFrom,
  rangeTo,
  onChange
}) {
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [selectedOption, setSelectedOption] = (0, _react.useState)([{
    value: environment,
    label: (0, _environment_filter_values.getEnvironmentLabel)(environment)
  }]);
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    onSearchChange,
    searchStatus
  } = (0, _use_environment_select.useEnvironmentSelect)({
    serviceName,
    start,
    end
  });
  const onSelect = changedOptions => {
    if (changedOptions.length === 1 && changedOptions[0].value) {
      onChange(changedOptions[0].value);
    }
    setSelectedOption(changedOptions);
  };
  const terms = (0, _react.useMemo)(() => {
    if (searchValue.trim() === '') {
      return availableEnvironments;
    }
    return [...new Set(data === null || data === void 0 ? void 0 : data.terms.concat(...availableEnvironments))];
  }, [availableEnvironments, data === null || data === void 0 ? void 0 : data.terms, searchValue]);
  const options = (0, _react.useMemo)(() => {
    const environmentOptions = getEnvironmentOptions(terms);
    return searchValue.trim() === '' ? environmentOptions : environmentOptions.filter(term => term.value.toLowerCase().includes(searchValue.toLowerCase()));
  }, [terms, searchValue]);
  const isInvalid = options.length === 0 && searchValue !== '';
  const onSearch = (0, _react.useCallback)(value => {
    setSearchValue(value);
    if (shouldFetch({
      newValue: value,
      oldValue: searchValue,
      optionList: terms
    })) {
      onSearchChange(value);
    }
  }, [onSearchChange, terms, searchValue]);

  // in case the combobox is left empty, returns the current selected environment stored in the URL state
  const onBlur = (0, _react.useCallback)(() => {
    setSelectedOption([{
      value: environment,
      label: (0, _environment_filter_values.getEnvironmentLabel)(environment)
    }]);
  }, [environment]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "aria-label": _i18n.i18n.translate('xpack.apm.environmentSelect.selectenvironmentComboBox.ariaLabel', {
      defaultMessage: 'Select environment'
    }),
    error: _i18n.i18n.translate('xpack.apm.filter.environment.error', {
      defaultMessage: '{value} is not a valid environment',
      values: {
        value: searchValue
      }
    }),
    css: {
      minWidth: '256px'
    },
    isInvalid: isInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "environmentFilter",
    async: true,
    compressed: true,
    isClearable: false,
    isInvalid: isInvalid,
    placeholder: _i18n.i18n.translate('xpack.apm.filter.environment.placeholder', {
      defaultMessage: 'Select environment'
    }),
    prepend: _i18n.i18n.translate('xpack.apm.filter.environment.label', {
      defaultMessage: 'Environment'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOption,
    onChange: onSelect,
    onSearchChange: onSearch,
    onBlur: onBlur,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING || searchStatus === _use_fetcher.FETCH_STATUS.LOADING,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }));
}