"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentOfParent = PercentOfParent;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _formatters = require("../../../../../common/utils/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/percent_of_parent.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PercentOfParent({
  duration,
  totalDuration,
  parentType
}) {
  totalDuration = totalDuration || duration;
  const isOver100 = duration > totalDuration;
  const percentOfParent = isOver100 ? '>100%' : (0, _formatters.asPercent)(duration, totalDuration, '');
  const percentOfParentText = _i18n.i18n.translate('xpack.apm.percentOfParent', {
    defaultMessage: '({value} of {parentType, select, transaction { transaction } trace {trace} other {unknown parentType} })',
    values: {
      value: percentOfParent,
      parentType
    }
  });
  const childType = parentType === 'trace' ? 'transaction' : 'span';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOver100 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.transactionDetails.percentOfTraceLabelExplanation', {
      defaultMessage: 'The % of {parentType, select, transaction {transaction} trace {trace} other {unknown parentType} } exceeds 100% because this {childType, select, span {span} transaction {transaction} other {unknown childType} } takes longer than the root transaction.',
      values: {
        parentType,
        childType
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, percentOfParentText)) : percentOfParentText);
}