"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilterButton = AddFilterButton;
exports.FiltersSection = FiltersSection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _suggestions_select = require("../../../../shared/suggestions_select");
var _helper = require("./helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_edit_custom_link_flyout/filters_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FiltersSection({
  filters,
  setFilters
}) {
  const onChangeFilter = (0, _react.useCallback)((key, value, id) => {
    const newFilters = filters.map(item => item.id === id ? {
      id,
      key,
      value
    } : item);
    setFilters(newFilters);
  }, [filters, setFilters]);
  const start = (0, _react.useMemo)(() => (0, _moment.default)().subtract(24, 'h').toISOString(), []);
  const end = (0, _react.useMemo)(() => (0, _moment.default)().toISOString(), []);
  const onRemoveFilter = id => {
    // remove without mutating original array
    const newFilters = filters.filter(item => item.id !== id);

    // if there is only one item left it should not be removed
    // but reset to empty
    if ((0, _lodash.isEmpty)(newFilters)) {
      setFilters([{
        key: '',
        value: '',
        id
      }]);
    } else {
      setFilters(newFilters);
    }
  };
  const handleAddFilter = () => {
    setFilters([...filters, {
      id: (0, _uuid.v4)(),
      key: '',
      value: ''
    }]);
  };
  (0, _react.useEffect)(() => {
    var _filters$;
    if (filters !== null && filters !== void 0 && filters.length && (0, _lodash.isEmpty)(filters[0].key) && !((_filters$ = filters[0]) !== null && _filters$ !== void 0 && _filters$.id)) {
      const initialFiltersWithId = filters.map(item => {
        return {
          ...item,
          id: (0, _uuid.v4)()
        };
      });
      setFilters(initialFiltersWithId);
    }
    return () => {};
  }, [filters, setFilters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.title', {
    defaultMessage: 'Filters'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.subtitle', {
    defaultMessage: 'Use the filter options to scope them to only appear for specific services.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), filters.map(filter => {
    const {
      key,
      value
    } = filter;
    if (!filter.id) {
      filter.id = (0, _uuid.v4)();
    }
    const filterId = filter.id;
    const selectOptions = (0, _helper.getSelectOptions)(filters, key);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: filterId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "aria-label": _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.ariaLabel', {
        defaultMessage: 'Choose a field to filter by'
      }),
      "data-test-subj": filterId,
      id: filterId,
      fullWidth: true,
      options: selectOptions,
      value: key,
      prepend: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.prepend', {
        defaultMessage: 'Field'
      }),
      onChange: e =>
      // set value to empty string to reset value when new field is selected
      onChangeFilter(e.target.value, '', filterId),
      isInvalid: !(0, _lodash.isEmpty)(value) && ((0, _lodash.isEmpty)(key) || key === _helper.DEFAULT_OPTION.value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
      key: filterId,
      dataTestSubj: `${key}.value`,
      fieldName: key,
      placeholder: _i18n.i18n.translate('xpack.apm.settings.customLink.flyOut.filters.defaultOption.value', {
        defaultMessage: 'Value'
      }),
      onChange: selectedValue => onChangeFilter(key, selectedValue, filterId),
      defaultValue: value,
      isInvalid: !(0, _lodash.isEmpty)(key) && (0, _lodash.isEmpty)(value),
      start: start,
      end: end,
      shouldReset: (0, _lodash.isEmpty)(key) || key === _helper.DEFAULT_OPTION.value,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.removeButton.ariaLabel', {
        defaultMessage: 'Remove filter'
      }),
      "data-test-subj": "apmCustomLinkFiltersSectionButton",
      iconType: "trash",
      onClick: () => onRemoveFilter(filterId),
      disabled: !value && !key && filters.length === 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AddFilterButton, {
    onClick: handleAddFilter
    // Disable button when user has already added all items available
    // or item is not properly setup (does not have key or value)
    ,
    isDisabled: filters.length === _helper.FILTER_SELECT_OPTIONS.length - 1 || filters.some(filter => (0, _lodash.isEmpty)(filter.key) || (0, _lodash.isEmpty)(filter.value)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }));
}
function AddFilterButton({
  onClick,
  isDisabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.addAnotherFilter.ariaLabel', {
      defaultMessage: 'Add another filter'
    }),
    "data-test-subj": "apmCustomLinkAddFilterButtonAddAnotherFilterButton",
    iconType: "plusInCircle",
    onClick: onClick,
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.filters.addAnotherFilter', {
    defaultMessage: 'Add another filter'
  }));
}