"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorGroupDetails = ErrorGroupDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _i18n2 = require("../../../../../../common/i18n");
var _use_apm_service_context = require("../../../../../context/apm_service/use_apm_service_context");
var _use_breadcrumb = require("../../../../../context/breadcrumbs/use_breadcrumb");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _use_error_group_distribution_fetcher = require("../../../../../hooks/use_error_group_distribution_fetcher");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../../hooks/use_time_range");
var _error_sampler = require("../../../error_group_details/error_sampler");
var _distribution = require("../shared/distribution");
var _chart_pointer_event_context = require("../../../../../context/chart_pointer_event/chart_pointer_event_context");
var _mobile_errors_and_crashes_treemap = require("../../charts/mobile_errors_and_crashes_treemap");
var _maybe = require("../../../../../../common/utils/maybe");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _get_kuery_with_mobile_filters = require("../../../../../../common/utils/get_kuery_with_mobile_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_group_details/error_group_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyErrorSamples = {
  errorSampleIds: [],
  occurrencesCount: 0
};
function getShortGroupId(errorGroupId) {
  if (!errorGroupId) {
    return _i18n2.NOT_AVAILABLE_LABEL;
  }
  return errorGroupId.slice(0, 5);
}
function ErrorGroupHeader({
  groupId,
  occurrencesCount
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.errorGroupDetails.errorGroupTitle', {
    defaultMessage: 'Error group {errorGroupId}',
    values: {
      errorGroupId: getShortGroupId(groupId)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.errorGroupDetails.occurrencesLabel', {
    defaultMessage: '{occurrencesCount} occ',
    values: {
      occurrencesCount
    }
  }))));
}
function ErrorGroupDetails() {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    path: {
      groupId
    },
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      serviceGroup,
      comparisonEnabled,
      errorId,
      device,
      osVersion,
      appVersion,
      netConnectionType
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}');
  const kueryWithMobileFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title: groupId,
    href: apmRouter.link('/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}', {
      path: {
        serviceName,
        groupId
      },
      query: {
        rangeFrom,
        rangeTo,
        environment,
        kuery: kueryWithMobileFilters,
        serviceGroup,
        comparisonEnabled
      }
    })
  }), [apmRouter, comparisonEnabled, environment, groupId, kueryWithMobileFilters, rangeFrom, rangeTo, serviceGroup, serviceName]);
  const {
    data: errorSamplesData = emptyErrorSamples,
    status: errorSamplesFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/{groupId}/samples', {
        params: {
          path: {
            serviceName,
            groupId
          },
          query: {
            environment,
            kuery: kueryWithMobileFilters,
            start,
            end
          }
        }
      });
    }
  }, [environment, kueryWithMobileFilters, serviceName, start, end, groupId]);
  const {
    errorDistributionData,
    errorDistributionStatus: errorDistributionStatus
  } = (0, _use_error_group_distribution_fetcher.useErrorGroupDistributionFetcher)({
    serviceName,
    groupId,
    environment,
    kuery: kueryWithMobileFilters
  });
  (0, _react.useEffect)(() => {
    const selectedSample = errorSamplesData === null || errorSamplesData === void 0 ? void 0 : errorSamplesData.errorSampleIds.find(sample => sample === errorId);
    if (errorSamplesFetchStatus === _use_fetcher.FETCH_STATUS.SUCCESS && !selectedSample) {
      // selected sample was not found. select a new one:
      const selectedErrorId = (0, _maybe.maybe)(errorSamplesData === null || errorSamplesData === void 0 ? void 0 : errorSamplesData.errorSampleIds[0]);
      history.replace({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _lodash.omit)((0, _url_helpers.toQuery)(history.location.search), ['errorId']),
          errorId: selectedErrorId
        })
      });
    }
  }, [history, errorId, errorSamplesData, errorSamplesFetchStatus]);

  // If there are 0 occurrences, show only charts w. empty message
  const showDetails = errorSamplesData.occurrencesCount !== 0;
  const kueryForTreemap = (0, _get_kuery_with_mobile_filters.getKueryWithMobileErrorFilter)({
    groupId,
    kuery: kueryWithMobileFilters
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ErrorGroupHeader, {
    groupId: groupId,
    occurrencesCount: errorSamplesData === null || errorSamplesData === void 0 ? void 0 : errorSamplesData.occurrencesCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_distribution.ErrorDistribution, {
    fetchStatus: errorDistributionStatus,
    distribution: errorDistributionData,
    title: _i18n.i18n.translate('xpack.apm.errorGroupDetails.occurrencesChartLabel', {
      defaultMessage: 'Error occurrences'
    }),
    height: 300,
    tip: _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.errorRateChart.tip', {
      defaultMessage: `Error rate is measured in transactions per minute.`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_mobile_errors_and_crashes_treemap.MobileErrorsAndCrashesTreemap, {
    serviceName: serviceName,
    kuery: `${kueryForTreemap}`,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }), showDetails && /*#__PURE__*/_react.default.createElement(_error_sampler.ErrorSampler, {
    errorSampleIds: errorSamplesData.errorSampleIds,
    errorSamplesFetchStatus: errorSamplesFetchStatus,
    occurrencesCount: errorSamplesData.occurrencesCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }));
}