"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyDetailView = DependencyDetailView;
var _react = _interopRequireDefault(require("react"));
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _dependencies = require("../../routing/home/dependencies");
var _dependency_detail_template = require("../../routing/templates/dependency_detail_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependency_detail_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DependencyDetailView({
  children
}) {
  const {
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      refreshInterval,
      refreshPaused,
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies');
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _dependencies.DependenciesInventoryTitle,
    href: apmRouter.link('/dependencies/inventory', {
      query: {
        rangeFrom,
        rangeTo,
        refreshInterval,
        refreshPaused,
        environment,
        kuery,
        comparisonEnabled
      }
    })
  }, {
    title: dependencyName,
    href: apmRouter.link('/dependencies', {
      query: {
        dependencyName,
        rangeFrom,
        rangeTo,
        refreshInterval,
        refreshPaused,
        environment,
        kuery,
        comparisonEnabled
      }
    })
  }], [apmRouter, comparisonEnabled, dependencyName, environment, kuery, rangeFrom, rangeTo, refreshInterval, refreshPaused], {
    omitRootOnServerless: true
  });
  return /*#__PURE__*/_react.default.createElement(_dependency_detail_template.DependencyDetailTemplate, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 10
    }
  }, children);
}