"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyScheduledBackfillsToGap = void 0;
var _constants = require("../../../../common/constants");
var _update_gap_from_schedule = require("./update_gap_from_schedule");
var _calculate_gaps_state = require("./calculate_gaps_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applyScheduledBackfillsToGap = async ({
  gap,
  scheduledItems,
  savedObjectsRepository,
  shouldRefetchAllBackfills,
  logger,
  backfillClient,
  actionsClient,
  ruleId,
  initiator
}) => {
  const hasFailedBackfillTask = scheduledItems.some(scheduleItem => scheduleItem.status === _constants.adHocRunStatus.ERROR || scheduleItem.status === _constants.adHocRunStatus.TIMEOUT);

  // Although calculateGapStateFromAllBackfills also calls updateGapFromSchedule,
  // it's crucial to call updateGapFromSchedule first with the current scheduled items.
  // This ensures that if a backfill has been deleted, we still update gaps based on any
  // completed scheduled items it contained. Since deleted backfills aren't returned on refetch,
  // calculateGapStateFromAllBackfills can't account for them.
  (0, _update_gap_from_schedule.updateGapFromSchedule)({
    gap,
    scheduledItems
  });
  if (initiator === _constants.backfillInitiator.SYSTEM && hasFailedBackfillTask) {
    gap.incrementFailedAutoFillAttempts();
  }
  if (hasFailedBackfillTask || scheduledItems.length === 0 || shouldRefetchAllBackfills) {
    await (0, _calculate_gaps_state.calculateGapStateFromAllBackfills)({
      gap,
      savedObjectsRepository,
      ruleId,
      backfillClient,
      actionsClient,
      logger
    });
  }
};
exports.applyScheduledBackfillsToGap = applyScheduledBackfillsToGap;