"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleIdsSchema = exports.ruleSnoozeScheduleSchema = exports.ruleResponseSchema = exports.ruleLastRunSchema = exports.ruleExecutionStatusSchema = exports.outcome = exports.notifyWhenSchema = exports.monitoringSchema = exports.mappedParamsSchema = exports.investigationGuideSchema = exports.dashboardsSchema = exports.artifactsSchema = exports.alertDelaySchema = exports.actionParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _responseOpsRuleParams = require("@kbn/response-ops-rule-params");
var _r_rule = require("../../../r_rule");
var _alerts_filter_query = require("../../../alerts_filter_query");
var _v = require("../../common/constants/v1");
var _validation = require("../../validation");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionParamsSchema = exports.actionParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()), {
  meta: {
    description: 'The parameters for the action, which are sent to the connector. The `params` are handled as Mustache templates and passed a default set of context.'
  }
});
const mappedParamsSchema = exports.mappedParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string({
  meta: {
    description: 'The mapped parameters for the rule.'
  }
}), _configSchema.schema.maybe(_configSchema.schema.any()));
const notifyWhenSchema = exports.notifyWhenSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleNotifyWhen.CHANGE), _configSchema.schema.literal(_v.ruleNotifyWhen.ACTIVE), _configSchema.schema.literal(_v.ruleNotifyWhen.THROTTLE)], {
  validate: _validation.validateNotifyWhenV1,
  meta: {
    description: 'Indicates how often alerts generate actions. Valid values include: `onActionGroupChange`: Actions run when the alert status changes; `onActiveAlert`: Actions run when the alert becomes active and at each check interval while the rule conditions are met; `onThrottleInterval`: Actions run when the alert becomes active and at the interval specified in the throttle property while the rule conditions are met. NOTE: You cannot specify `notify_when` at both the rule and action level. The recommended method is to set it for each action. If you set it at the rule level then update the rule in Kibana, it is automatically changed to use action-specific values.'
  }
});
const intervalScheduleSchema = _configSchema.schema.object({
  interval: _configSchema.schema.string({
    meta: {
      description: 'The interval is specified in seconds, minutes, hours, or days.'
    }
  })
});
const actionFrequencySchema = _configSchema.schema.object({
  summary: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the action is a summary.'
    }
  }),
  notify_when: notifyWhenSchema,
  throttle: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: `The throttle interval, which defines how often an alert generates repeated actions. It is specified in seconds, minutes, hours, or days and is applicable only if 'notify_when' is set to 'onThrottleInterval'. NOTE: You cannot specify the throttle interval at both the rule and action level. The recommended method is to set it for each action. If you set it at the rule level then update the rule in Kibana, it is automatically changed to use action-specific values.`
    }
  }))
});
const actionAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_alerts_filter_query.alertsFilterQuerySchemaV1),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)]), {
      meta: {
        description: 'Defines the days of the week that the action can run, represented as an array of numbers. For example, `1` represents Monday. An empty array is equivalent to specifying all the days of the week.'
      }
    }),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string({
        meta: {
          description: 'The start of the time frame in 24-hour notation (`hh:mm`).'
        }
      }),
      end: _configSchema.schema.string({
        meta: {
          description: 'The end of the time frame in 24-hour notation (`hh:mm`).'
        }
      })
    }),
    timezone: _configSchema.schema.string({
      meta: {
        description: 'The ISO time zone for the `hours` values. Values such as `UTC` and `UTC+1` also work but lack built-in daylight savings time support and are not recommended.'
      }
    })
  }))
}, {
  meta: {
    description: 'Defines a period that limits whether the action runs.'
  }
});
const actionSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'A universally unique identifier (UUID) for the action.'
    }
  })),
  group: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: "The group name, which affects when the action runs (for example, when the threshold is met or when the alert is recovered). Each rule type has a list of valid action group names. If you don't need to group actions, set to `default`."
    }
  })),
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the connector saved object.'
    }
  }),
  connector_type_id: _configSchema.schema.string({
    meta: {
      description: 'The type of connector. This property appears in responses but cannot be set in requests.'
    }
  }),
  params: actionParamsSchema,
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  alerts_filter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  use_alert_data_for_template: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether to use alert data as a template.'
    }
  }))
});
const ruleExecutionStatusSchema = exports.ruleExecutionStatusSchema = _configSchema.schema.object({
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusValues.OK), _configSchema.schema.literal(_v.ruleExecutionStatusValues.ACTIVE), _configSchema.schema.literal(_v.ruleExecutionStatusValues.ERROR), _configSchema.schema.literal(_v.ruleExecutionStatusValues.WARNING), _configSchema.schema.literal(_v.ruleExecutionStatusValues.PENDING), _configSchema.schema.literal(_v.ruleExecutionStatusValues.UNKNOWN)], {
    meta: {
      description: 'Status of rule execution.'
    }
  }),
  last_execution_date: _configSchema.schema.string({
    meta: {
      description: 'The date and time when rule was executed last.'
    }
  }),
  last_duration: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Duration of last execution of the rule.'
    }
  })),
  error: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.VALIDATE)], {
      meta: {
        description: 'Reason for error.'
      }
    }),
    message: _configSchema.schema.string({
      meta: {
        description: 'Error message.'
      }
    })
  })),
  warning: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.EXECUTION)], {
      meta: {
        description: 'Reason for warning.'
      }
    }),
    message: _configSchema.schema.string({
      meta: {
        description: 'Warning message.'
      }
    })
  }))
});
const outcome = exports.outcome = _configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleLastRunOutcomeValues.SUCCEEDED), _configSchema.schema.literal(_v.ruleLastRunOutcomeValues.WARNING), _configSchema.schema.literal(_v.ruleLastRunOutcomeValues.FAILED)], {
  meta: {
    description: 'Outcome of last run of the rule. Value could be succeeded, warning or failed.'
  }
});
const ruleLastRunSchema = exports.ruleLastRunSchema = _configSchema.schema.object({
  outcome,
  outcome_order: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Order of the outcome.'
    }
  })),
  warning: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_v.ruleExecutionStatusErrorReason.VALIDATE), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS), _configSchema.schema.literal(_v.ruleExecutionStatusWarningReason.EXECUTION)], {
    meta: {
      description: 'Warning of last rule execution.'
    }
  }))),
  outcome_msg: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Outcome message generated during last rule run.'
    }
  })))),
  alerts_count: _configSchema.schema.object({
    active: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
      meta: {
        description: 'Number of active alerts during last run.'
      }
    }))),
    new: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
      meta: {
        description: 'Number of new alerts during last run.'
      }
    }))),
    recovered: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
      meta: {
        description: 'Number of recovered alerts during last run.'
      }
    }))),
    ignored: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
      meta: {
        description: 'Number of ignored alerts during last run.'
      }
    })))
  })
});
const monitoringSchema = exports.monitoringSchema = _configSchema.schema.object({
  run: _configSchema.schema.object({
    history: _configSchema.schema.arrayOf(_configSchema.schema.object({
      success: _configSchema.schema.boolean({
        meta: {
          description: 'Indicates whether the rule run was successful.'
        }
      }),
      timestamp: _configSchema.schema.number({
        meta: {
          description: 'Time of rule run.'
        }
      }),
      duration: _configSchema.schema.maybe(_configSchema.schema.number({
        meta: {
          description: 'Duration of the rule run.'
        }
      })),
      outcome: _configSchema.schema.maybe(outcome)
    }), {
      meta: {
        description: 'History of the rule run.'
      }
    }),
    calculated_metrics: _configSchema.schema.object({
      p50: _configSchema.schema.maybe(_configSchema.schema.number()),
      p95: _configSchema.schema.maybe(_configSchema.schema.number()),
      p99: _configSchema.schema.maybe(_configSchema.schema.number()),
      success_ratio: _configSchema.schema.number()
    }, {
      meta: {
        description: 'Calculation of different percentiles and success ratio.'
      }
    }),
    last_run: _configSchema.schema.object({
      timestamp: _configSchema.schema.string({
        meta: {
          description: 'Time of the most recent rule run.'
        }
      }),
      metrics: _configSchema.schema.object({
        duration: _configSchema.schema.maybe(_configSchema.schema.number({
          meta: {
            description: 'Duration of most recent rule run.'
          }
        })),
        total_search_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
          meta: {
            description: 'Total time spent performing Elasticsearch searches as measured by Kibana; includes network latency and time spent serializing or deserializing the request and response.'
          }
        }))),
        total_indexing_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
          meta: {
            description: 'Total time spent indexing documents during last rule run in milliseconds.'
          }
        }))),
        total_alerts_detected: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
          meta: {
            description: 'Total number of alerts detected during last rule run.'
          }
        }))),
        total_alerts_created: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
          meta: {
            description: 'Total number of alerts created during last rule run.'
          }
        }))),
        gap_duration_s: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number({
          meta: {
            description: 'Duration in seconds of rule run gap.'
          }
        }))),
        gap_range: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.object({
          lte: _configSchema.schema.string({
            meta: {
              description: 'Start of the gap range.'
            }
          }),
          gte: _configSchema.schema.string({
            meta: {
              description: 'End of the gap range.'
            }
          })
        })))
      })
    })
  }, {
    meta: {
      description: 'Rule run details.'
    }
  })
}, {
  meta: {
    description: 'Monitoring details of the rule.'
  }
});
const ruleSnoozeScheduleSchema = exports.ruleSnoozeScheduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Identifier of the rule snooze schedule.'
    }
  })),
  duration: _configSchema.schema.number({
    meta: {
      description: 'Duration of the rule snooze schedule.'
    }
  }),
  rRule: _r_rule.rRuleResponseSchemaV1,
  skipRecurrences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Skips recurrence of rule on this date.'
    }
  })))
});
const alertDelaySchema = exports.alertDelaySchema = _configSchema.schema.object({
  active: _configSchema.schema.number({
    meta: {
      description: 'The number of consecutive runs that must meet the rule conditions.'
    }
  })
}, {
  meta: {
    description: 'Indicates that an alert occurs only when the specified number of consecutive runs met the rule conditions.'
  }
});
const dashboardsSchema = exports.dashboardsSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  id: _configSchema.schema.string()
}));
const investigationGuideSchema = exports.investigationGuideSchema = _configSchema.schema.object({
  blob: _configSchema.schema.string({
    meta: {
      description: 'User-created content that describes alert causes and remdiation.'
    }
  })
});
const artifactsSchema = exports.artifactsSchema = _configSchema.schema.object({
  dashboards: _configSchema.schema.maybe(dashboardsSchema),
  investigation_guide: _configSchema.schema.maybe(investigationGuideSchema)
});
const ruleResponseSchema = exports.ruleResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the rule.'
    }
  }),
  enabled: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether you want to run the rule on an interval basis after it is created.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: ' The name of the rule.'
    }
  }),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'The tags for the rule.'
    }
  })),
  rule_type_id: _configSchema.schema.string({
    meta: {
      description: 'The rule type identifier.'
    }
  }),
  consumer: _configSchema.schema.string({
    meta: {
      description: 'The name of the application or feature that owns the rule. For example: `alerts`, `apm`, `discover`, `infrastructure`, `logs`, `metrics`, `ml`, `monitoring`, `securitySolution`, `siem`, `stackAlerts`, or `uptime`.'
    }
  }),
  schedule: intervalScheduleSchema,
  actions: _configSchema.schema.arrayOf(actionSchema),
  params: _responseOpsRuleParams.ruleParamsSchemaV1,
  mapped_params: _configSchema.schema.maybe(mappedParamsSchema),
  scheduled_task_id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Identifier of the scheduled task.'
    }
  })),
  created_by: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The identifier for the user that created the rule.'
    }
  })),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The identifier for the user that updated this rule most recently.'
    }
  })),
  created_at: _configSchema.schema.string({
    meta: {
      description: 'The date and time that the rule was created.'
    }
  }),
  updated_at: _configSchema.schema.string({
    meta: {
      description: 'The date and time that the rule was updated most recently.'
    }
  }),
  api_key_owner: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The owner of the API key that is associated with the rule and used to run background tasks.'
    }
  })),
  api_key_created_by_user: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the API key that is associated with the rule was created by the user.'
    }
  }))),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'Deprecated in 8.13.0. Use the `throttle` property in the action `frequency` object instead. The throttle interval, which defines how often an alert generates repeated actions. NOTE: You cannot specify the throttle interval at both the rule and action level. If you set it at the rule level then update the rule in Kibana, it is automatically changed to use action-specific values.',
      deprecated: true
    }
  }))),
  mute_all: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether all alerts are muted.'
    }
  }),
  notify_when: _configSchema.schema.maybe(_configSchema.schema.nullable(notifyWhenSchema)),
  muted_alert_ids: _configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'List of identifiers of muted alerts. '
    }
  })),
  execution_status: ruleExecutionStatusSchema,
  monitoring: _configSchema.schema.maybe(monitoringSchema),
  snooze_schedule: _configSchema.schema.maybe(_configSchema.schema.arrayOf(ruleSnoozeScheduleSchema)),
  active_snoozes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: `List of active snoozes for the rule.`
    }
  }))),
  is_snoozed_until: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The date when the rule will no longer be snoozed.'
    }
  }))),
  last_run: _configSchema.schema.maybe(_configSchema.schema.nullable(ruleLastRunSchema)),
  next_run: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'Date and time of the next run of the rule.'
    }
  }))),
  revision: _configSchema.schema.number({
    meta: {
      description: 'The rule revision number.'
    }
  }),
  running: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule is running.'
    }
  }))),
  view_in_app_relative_url: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'Relative URL to view rule in the app.'
    }
  }))),
  alert_delay: _configSchema.schema.maybe(alertDelaySchema),
  flapping: _configSchema.schema.maybe(_configSchema.schema.nullable(_common.flappingSchemaV2)),
  artifacts: _configSchema.schema.maybe(artifactsSchema)
});
const scheduleIdsSchema = exports.scheduleIdsSchema = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));