"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangeSchema = exports.rangeListSchema = exports.gapsResponseSchema = exports.gapStatusSchema = exports.errorResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const gapStatusSchema = exports.gapStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.gapStatus.UNFILLED), _configSchema.schema.literal(_constants.gapStatus.FILLED), _configSchema.schema.literal(_constants.gapStatus.PARTIALLY_FILLED)]);
const rangeSchema = exports.rangeSchema = _configSchema.schema.object({
  lte: _configSchema.schema.string(),
  gte: _configSchema.schema.string()
});
const rangeListSchema = exports.rangeListSchema = _configSchema.schema.arrayOf(rangeSchema);
const gapsResponseSchema = exports.gapsResponseSchema = _configSchema.schema.object({
  '@timestamp': _configSchema.schema.string(),
  _id: _configSchema.schema.string(),
  status: gapStatusSchema,
  range: rangeSchema,
  in_progress_intervals: rangeListSchema,
  filled_intervals: rangeListSchema,
  unfilled_intervals: rangeListSchema,
  total_gap_duration_ms: _configSchema.schema.number(),
  filled_duration_ms: _configSchema.schema.number(),
  unfilled_duration_ms: _configSchema.schema.number(),
  in_progress_duration_ms: _configSchema.schema.number(),
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  failed_auto_fill_attempts: _configSchema.schema.maybe(_configSchema.schema.number())
});
const errorResponseSchema = exports.errorResponseSchema = _configSchema.schema.object({
  error: _configSchema.schema.object({
    message: _configSchema.schema.string(),
    status: _configSchema.schema.maybe(_configSchema.schema.number())
  })
});