"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gapAutoFillSchedulerResponseSchema = exports.gapAutoFillSchedulerBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _constants = require("../../../../../constants");
var _parse_duration = require("../../../../../parse_duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  maxBackfills,
  numRetries,
  minScheduleIntervalInMs
} = _constants.gapAutoFillSchedulerLimits;
const gapAutoFillSchedulerBodySchema = exports.gapAutoFillSchedulerBodySchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  name: _configSchema.schema.string({
    defaultValue: ''
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  max_backfills: _configSchema.schema.number(maxBackfills),
  num_retries: _configSchema.schema.number(numRetries),
  gap_fill_range: _configSchema.schema.string({
    defaultValue: 'now-90d'
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  rule_types: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  }))
}, {
  validate({
    gap_fill_range: gapFillRange,
    schedule,
    rule_types: ruleTypes
  }) {
    const now = new Date();
    const parsed = _datemath.default.parse(gapFillRange, {
      forceNow: now
    });
    if (!parsed || !parsed.isValid()) {
      return 'gap_fill_range is invalid';
    }
    const maxLookbackExpression = `now-${_constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_DAYS}d`;
    const lookbackLimit = _datemath.default.parse(maxLookbackExpression, {
      forceNow: now
    });
    if (!lookbackLimit || !lookbackLimit.isValid()) {
      return 'gap_fill_range is invalid';
    }
    if (parsed.isBefore(lookbackLimit)) {
      return `gap_fill_range cannot look back more than ${_constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_DAYS} days`;
    }
    try {
      const intervalMs = (0, _parse_duration.parseDuration)(schedule.interval);
      if (intervalMs < minScheduleIntervalInMs) {
        return 'schedule.interval must be at least 1 minute';
      }
    } catch (error) {
      return `schedule.interval is invalid: ${error.message}`;
    }

    // Duplicate check for rule_types
    const seen = new Set();
    for (const ruleType of ruleTypes) {
      const key = `${ruleType.type}:${ruleType.consumer}`;
      if (seen.has(key)) {
        return `rule_types contains duplicate entry: type="${ruleType.type}" consumer="${ruleType.consumer}"`;
      }
      seen.add(key);
    }
  }
});
const gapAutoFillSchedulerResponseSchema = exports.gapAutoFillSchedulerResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  rule_types: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  })),
  gap_fill_range: _configSchema.schema.string(),
  max_backfills: _configSchema.schema.number(),
  num_retries: _configSchema.schema.number(),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  created_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  created_at: _configSchema.schema.string(),
  updated_at: _configSchema.schema.string()
});