"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedField = exports.FieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _render_custom_toolbar = require("@kbn/unified-data-table/src/components/custom_toolbar/render_custom_toolbar");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectedField = ({
  fields,
  selectedField,
  setSelectedField
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const togglePopover = () => setShowPopover(!showPopover);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiDataGridToolbarControl, {
    "data-test-subj": "aiopsEmbeddableSelectFieldButton",
    onClick: () => togglePopover(),
    "aria-haspopup": "dialog",
    "aria-expanded": showPopover,
    "aria-label": selectedField ? _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.selectedFieldButtonAriaLabel', {
      defaultMessage: 'Selected field: {fieldName}',
      values: {
        fieldName: selectedField === null || selectedField === void 0 ? void 0 : selectedField.name
      }
    }) : _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.noSelectedFieldButtonAriaLabel', {
      defaultMessage: 'Select field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: "tokenString",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, selectedField === null || selectedField === void 0 ? void 0 : selectedField.name)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setShowPopover(false),
    isOpen: showPopover,
    button: button,
    className: "unifiedDataTableToolbarControlButton",
    css: _render_custom_toolbar.styles.controlButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FieldSelector, {
    fields: fields,
    selectedField: selectedField,
    setSelectedField: setSelectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
};
exports.SelectedField = SelectedField;
const FieldSelector = ({
  fields,
  selectedField,
  setSelectedField,
  WarningComponent
}) => {
  const fieldOptions = (0, _react.useMemo)(() => fields.map(field => ({
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: field.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 23
      }
    }),
    value: field
  })), [fields]);
  const fieldId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldSelector',
    suffix: 'select'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, WarningComponent !== undefined ? /*#__PURE__*/_react.default.createElement(WarningComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 41
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "aiopsEmbeddableMenuSelectedFieldFormRow",
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.selectedFieldRowLabel', {
      defaultMessage: 'Selected field'
    }),
    id: fieldId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    compressed: true,
    options: fieldOptions,
    disabled: fields.length === 0,
    valueOfSelected: selectedField !== null && selectedField !== void 0 ? selectedField : undefined,
    onChange: setSelectedField,
    css: {
      minWidth: 250
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })));
};
exports.FieldSelector = FieldSelector;