"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiProgressValueTextStyles = exports.euiProgressStyles = exports.euiProgressLabelStyles = exports.euiProgressDataStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _services = require("../../services");
var _text = require("../text/text.styles");
var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * DRY utilities for native/determinate progress components vs non-native indeterminate
 */
var crossBrowserProgressValue = function crossBrowserProgressValue(cssProperties) {
  return "\n  &::-webkit-progress-value {\n    ".concat(cssProperties, "\n  }\n  &::-moz-progress-bar {\n    ").concat(cssProperties, "\n  }\n");
};
var indeterminateProgressValue = function indeterminateProgressValue(cssProperties) {
  return "\n  &::before {\n    ".concat(cssProperties, "\n  }\n");
};

/**
 * Color utilities
 */

var nativeVsIndeterminateColor = function nativeVsIndeterminateColor(color, isNative, highContrastMode) {
  var selectors = isNative ? crossBrowserProgressValue : indeterminateProgressValue;
  return "\n    ".concat(selectors("background-color: ".concat(color, ";")), "\n    ").concat(isNative && highContrastMode === 'preferred' // see highContrastModeStyles.preferred comment below
  ? "border-color: ".concat(color, ";") : '', "\n  ").trim();
};

/**
 * DRY utils for non-static positions
 */
var nonStaticPositioning = function nonStaticPositioning(isNative) {
  return "\n  ".concat((0, _global_styling.logicalCSS)('top', 0), "\n  ").concat((0, _global_styling.logicalCSS)('left', 0), "\n  ").concat((0, _global_styling.logicalCSS)('right', 0), "\n  background-color: transparent;\n  ").concat(isNative ? "\n      &::-webkit-progress-bar {\n        background-color: transparent;\n      }" : '', "\n");
};

/**
 * Animations
 */
var euiIndeterminateAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: scaleX(1) translateX(-100%);\n  }\n  100% {\n    transform: scaleX(1) translateX(100%);\n  }\n"])));

/**
 * Emotion styles
 */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "187h6sp-static",
  styles: "position:relative;label:static;"
} : {
  name: "187h6sp-static",
  styles: "position:relative;label:static;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiProgressStyles = exports.euiProgressStyles = function euiProgressStyles(euiThemeContext, isNative) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var backgroundColor = highContrastMode ? euiTheme.colors.emptyShade : euiTheme.colors.lightShade;
  return {
    euiProgress: /*#__PURE__*/(0, _react.css)("overflow:hidden;background-color:", backgroundColor, ";;label:euiProgress;"),
    // https://css-tricks.com/html5-progress-element/
    // Good resource if you need to work in here. There's some gotchas with
    // dealing with cross-browser progress bars.
    native: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), " &::-webkit-progress-bar{background-color:", backgroundColor, ";}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          appearance: none;\n          border: none;\n          border-radius: ".concat(euiTheme.size.s, ";\n        "),
      // For some reason we absolutely cannot set any border CSS in Windows high contrast
      // or the native element stops rendering. However, we do want the extra border for
      // MacOS high contrast, so #ternarylife
      preferred: highContrastMode !== 'forced' ? "\n              border: ".concat(euiTheme.border.thin, ";\n              border-radius: ").concat(euiTheme.size.s, ";\n              ").concat((0, _global_styling.logicalCSS)('min-height', euiTheme.size.s), "\n            ") :
      // Increase small sizes, otherwise the border is hard to distinguish,
      // However, native element heights seem to render differently,
      // so we need to tweak the min-height accordingly
      (0, _global_styling.logicalCSS)('min-height', euiTheme.size.m),
      // Also doesn't render without this ¯\_(ツ)_/¯
      forced: 'background-color: revert;'
    }), " ", _global_styling.euiCanAnimate, "{/* Note: FF/Mozilla doesn't actually support animating the native progress bar\n          @see https://bugzilla.mozilla.org/show_bug.cgi?id=662351 */", crossBrowserProgressValue("transition: width ".concat(euiTheme.animation.normal, " linear")), ";};label:native;"),
    // An indeterminate bar has an unreliable end time. Because of a Firefox animation issue,
    // we apply this style to a <div> instead of a <progress> element.
    // See https://css-tricks.com/html5-progress-element/ for more info.
    indeterminate: /*#__PURE__*/(0, _react.css)("&::before{position:absolute;content:'';", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('left', 0), " transform:scaleX(0) translateX(0%);animation:", euiIndeterminateAnimation, " 1s ", euiTheme.animation.resistance, " infinite;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Windows high contrast themes ignore backgrounds, so use a border instead
      forced: "\n            ".concat((0, _global_styling.logicalCSS)('border-top-style', 'solid'), "\n            ").concat((0, _global_styling.logicalCSS)('border-top-color', 'transparent'), "\n          ")
    }), ";", _global_styling.euiCantAnimate, "{animation:none;transform:scaleX(1) translateX(0%);background:repeating-linear-gradient(\n            -45deg,\n            transparent,\n            transparent ", euiTheme.size.m, ",\n            rgb(0, 0, 0, 0.25) ", euiTheme.size.m, ",\n            rgb(0, 0, 0, 0.25) ", euiTheme.size.l, "\n          );}};label:indeterminate;"),
    // Sizes
    _sharedSizeCSS: function _sharedSizeCSS(size) {
      return "\n      ".concat((0, _global_styling.logicalCSS)('height', size), "\n      ").concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
        forced: "\n          &::before {\n            ".concat((0, _global_styling.logicalCSS)('border-top-width', size), "\n          }")
      }), "\n    ");
    },
    get xs() {
      return /*#__PURE__*/(0, _react.css)(
      // Increased visibility/size for high contrast modes
      this._sharedSizeCSS(highContrastMode ? euiTheme.size.xs : euiTheme.size.xxs), ";label:xs;");
    },
    get s() {
      return /*#__PURE__*/(0, _react.css)(this._sharedSizeCSS(euiTheme.size.xs), ";label:s;");
    },
    get m() {
      return /*#__PURE__*/(0, _react.css)(this._sharedSizeCSS(euiTheme.size.s), ";label:m;");
    },
    get l() {
      return /*#__PURE__*/(0, _react.css)(this._sharedSizeCSS(euiTheme.size.m), ";label:l;");
    },
    // Positioning
    fixed: /*#__PURE__*/(0, _react.css)("position:fixed;z-index:", Number(euiTheme.levels.header) + 1, ";", nonStaticPositioning(isNative), ";;label:fixed;"),
    absolute: /*#__PURE__*/(0, _react.css)("position:absolute;", nonStaticPositioning(isNative), " ", (0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), ";;label:absolute;"),
    static: _ref2,
    // Colors
    primary: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.primary, isNative, highContrastMode), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.success, isNative, highContrastMode), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.warning, isNative, highContrastMode), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.danger, isNative, highContrastMode), ";;label:danger;"),
    subdued: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.textSubdued, isNative, highContrastMode), ";;label:subdued;"),
    accent: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.accent, isNative, highContrastMode), ";;label:accent;"),
    accentSecondary: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.accentSecondary, isNative, highContrastMode), ";;label:accentSecondary;"),
    vis0: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis0, isNative, highContrastMode), ";;label:vis0;"),
    vis1: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis1, isNative, highContrastMode), ";;label:vis1;"),
    vis2: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis2, isNative, highContrastMode), ";;label:vis2;"),
    vis3: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis3, isNative, highContrastMode), ";;label:vis3;"),
    vis4: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis4, isNative, highContrastMode), ";;label:vis4;"),
    vis5: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis5, isNative, highContrastMode), ";;label:vis5;"),
    vis6: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis6, isNative, highContrastMode), ";;label:vis6;"),
    vis7: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis7, isNative, highContrastMode), ";;label:vis7;"),
    vis8: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis8, isNative, highContrastMode), ";;label:vis8;"),
    vis9: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.vis.euiColorVis9, isNative, highContrastMode), ";;label:vis9;"),
    customColor: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor('currentColor', isNative, highContrastMode), ";;label:customColor;")
  };
};

/**
 * Data styles
 */
var euiProgressDataStyles = exports.euiProgressDataStyles = function euiProgressDataStyles(euiThemeContext) {
  return {
    euiProgress__data: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:space-between;gap:", euiThemeContext.euiTheme.size.xs, ";", (0, _text.euiText)(euiThemeContext.euiTheme), " ", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:euiProgress__data;"),
    // Sizes
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:l;")
  };
};
var euiProgressLabelStyles = exports.euiProgressLabelStyles = {
  euiProgress__label: /*#__PURE__*/(0, _react.css)("flex-grow:1;", (0, _global_styling.euiTextTruncate)(), ";;label:euiProgress__label;")
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;"
} : {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiProgressValueTextStyles = exports.euiProgressValueTextStyles = function euiProgressValueTextStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiProgress__valueText: /*#__PURE__*/(0, _react.css)("flex-grow:1;flex-shrink:0;font-feature-settings:'tnum' 1;", (0, _global_styling.logicalTextAlignCSS)('right'), " ", (0, _global_styling.euiTextTruncate)(), ";;label:euiProgress__valueText;"),
    // Colors
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textPrimary, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSuccess, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textWarning, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDanger, ";;label:danger;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSubdued, ";;label:subdued;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccent, ";;label:accent;"),
    accentSecondary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccentSecondary, ";;label:accentSecondary;"),
    vis0: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis0)(euiTheme), ";;label:vis0;"),
    vis1: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis1)(euiTheme), ";;label:vis1;"),
    vis2: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis2)(euiTheme), ";;label:vis2;"),
    vis3: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis3)(euiTheme), ";;label:vis3;"),
    vis4: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis4)(euiTheme), ";;label:vis4;"),
    vis5: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis5)(euiTheme), ";;label:vis5;"),
    vis6: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis6)(euiTheme), ";;label:vis6;"),
    vis7: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis7)(euiTheme), ";;label:vis7;"),
    vis8: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis8)(euiTheme), ";;label:vis8;"),
    vis9: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(euiTheme.colors.vis.euiColorVis9)(euiTheme), ";;label:vis9;"),
    customColor: _ref
  };
};