/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequestHelper;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.node.VersionInformation;
import org.elasticsearch.cluster.project.DefaultProjectResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.RecordingMeterRegistry;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.TestEsExecutors;
import org.elasticsearch.test.tasks.MockTaskManager;
import org.elasticsearch.test.transport.StubbableConnectionManager;
import org.elasticsearch.test.transport.StubbableTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ClusterSettingsLinkedProjectConfigService;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.junit.Assert;

public class MockTransportService
extends TransportService {
    private static final Logger logger = LogManager.getLogger(MockTransportService.class);
    private final Map<DiscoveryNode, List<Transport.Connection>> openConnections = new HashMap<DiscoveryNode, List<Transport.Connection>>();
    private final List<Runnable> onStopListeners = new CopyOnWriteArrayList<Runnable>();
    private final AtomicReference<Consumer<Transport.Connection>> onConnectionClosedCallback = new AtomicReference();
    private final DelegatingTransportMessageListener messageListener = new DelegatingTransportMessageListener();
    private final Transport original;
    private final EsThreadPoolExecutor testExecutor;

    public static MockTransportService createNewService(Settings settings, VersionInformation version, TransportVersion transportVersion, ThreadPool threadPool) {
        return MockTransportService.createNewService(settings, version, transportVersion, threadPool, null);
    }

    public static MockTransportService createNewService(Settings settings, VersionInformation version, TransportVersion transportVersion, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings) {
        return MockTransportService.createNewService(settings, (Transport)MockTransportService.newMockTransport(settings, transportVersion, threadPool), version, threadPool, clusterSettings, Collections.emptySet());
    }

    public static TcpTransport newMockTransport(Settings settings, TransportVersion version, ThreadPool threadPool) {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, List.of());
        List namedWriteables = CollectionUtils.concatLists((List)searchModule.getNamedWriteables(), (Collection)ClusterModule.getNamedWriteables());
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
        return MockTransportService.newMockTransport(settings, version, threadPool, namedWriteableRegistry);
    }

    public static TcpTransport newMockTransport(Settings settings, TransportVersion version, ThreadPool threadPool, NamedWriteableRegistry namedWriteableRegistry) {
        settings = Settings.builder().put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).put(settings).build();
        return new Netty4Transport(settings, version, threadPool, new NetworkService(Collections.emptyList()), (PageCacheRecycler)new MockPageCacheRecycler(settings), namedWriteableRegistry, (CircuitBreakerService)new NoneCircuitBreakerService(), new SharedGroupFactory(settings));
    }

    public static MockTransportService createNewService(Settings settings, Transport transport, VersionInformation version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        return MockTransportService.createNewService(settings, transport, version, threadPool, clusterSettings, taskHeaders, NOOP_TRANSPORT_INTERCEPTOR);
    }

    public static MockTransportService createNewService(Settings settings, Transport transport, VersionInformation version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, TransportInterceptor interceptor) {
        String nodeId = UUIDs.randomBase64UUID();
        return new MockTransportService(settings, transport, threadPool, interceptor, boundAddress -> DiscoveryNodeUtils.builder(nodeId).name((String)Node.NODE_NAME_SETTING.get(settings)).address(boundAddress.publishAddress()).attributes(Node.NODE_ATTRIBUTES.getAsMap(settings)).roles(DiscoveryNode.getRolesFromSettings((Settings)settings)).version(version).build(), clusterSettings, taskHeaders, nodeId);
    }

    public static MockTransportService getInstance(String nodeName) {
        Assert.assertNotNull((String)"nodeName must not be null", (Object)nodeName);
        return ESTestCase.asInstanceOf(MockTransportService.class, ESIntegTestCase.internalCluster().getInstance(TransportService.class, nodeName));
    }

    public static MockTransportService createMockTransportService(Transport transport, ThreadPool threadPool) {
        String nodeId = UUIDs.randomBase64UUID();
        return new MockTransportService(Settings.EMPTY, transport, threadPool, TransportService.NOOP_TRANSPORT_INTERCEPTOR, boundAddress -> DiscoveryNodeUtils.builder(nodeId).address(boundAddress.publishAddress()).build(), null, Set.of(), nodeId);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, String nodeId) {
        this(settings, new StubbableTransport(transport), threadPool, interceptor, localNodeFactory, clusterSettings, MockTaskManager.create(settings, threadPool, taskHeaders, Tracer.NOOP, nodeId), (LinkedProjectConfigService)new ClusterSettingsLinkedProjectConfigService(settings, clusterSettings, (ProjectResolver)DefaultProjectResolver.INSTANCE), new TelemetryProvider(){
            final MeterRegistry meterRegistry = new RecordingMeterRegistry();

            public Tracer getTracer() {
                return Tracer.NOOP;
            }

            public MeterRegistry getMeterRegistry() {
                return this.meterRegistry;
            }
        }, (ProjectResolver)DefaultProjectResolver.INSTANCE);
    }

    public MockTransportService(Settings settings, StubbableTransport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, TaskManager taskManager, LinkedProjectConfigService linkedProjectConfigService, TelemetryProvider telemetryProvider, ProjectResolver projectResolver) {
        super(settings, (Transport)transport, threadPool, interceptor, localNodeFactory, clusterSettings, (ConnectionManager)new StubbableConnectionManager((ConnectionManager)new ClusterConnectionManager(settings, (Transport)transport, threadPool.getThreadContext())), taskManager, linkedProjectConfigService, telemetryProvider, projectResolver);
        this.original = transport.getDelegate();
        this.testExecutor = EsExecutors.newScaling((String)"mock-transport", (int)1, (int)4, (long)30L, (TimeUnit)TimeUnit.SECONDS, (boolean)true, (ThreadFactory)TestEsExecutors.testOnlyDaemonThreadFactory("mock-transport"), (ThreadContext)threadPool.getThreadContext());
    }

    private static TransportAddress[] extractTransportAddresses(TransportService transportService) {
        HashSet<TransportAddress> transportAddresses = new HashSet<TransportAddress>();
        BoundTransportAddress boundTransportAddress = transportService.boundAddress();
        transportAddresses.addAll(Arrays.asList(boundTransportAddress.boundAddresses()));
        transportAddresses.add(boundTransportAddress.publishAddress());
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    public void clearAllRules() {
        this.transport().clearBehaviors();
        this.connectionManager().clearBehaviors();
    }

    public void clearInboundRules() {
        this.transport().clearInboundBehaviors();
    }

    public void clearOutboundRules(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.clearOutboundRules(transportAddress);
        }
    }

    public void clearOutboundRules(TransportAddress transportAddress) {
        this.transport().clearOutboundBehaviors(transportAddress);
        this.connectionManager().clearBehavior(transportAddress);
    }

    public void addFailToSendNoConnectRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "DISCONNECT: simulated")));
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            connection.close();
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addFailToSendNoConnectRule(TransportService transportService, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportService, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportService transportService, Set<String> blockedActions) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress, blockedActions);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, Set<String> blockedActions) {
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            if (blockedActions.contains(action)) {
                logger.info("--> preventing {} request", (Object)action);
                connection.close();
            }
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addUnresponsiveRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated")));
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(this){
            private final Set<Transport.Connection> toClose = ConcurrentHashMap.newKeySet();
            private final RefCounted refs = AbstractRefCounted.of(this::closeConnections);

            @Override
            public void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
                if (connection.isClosed()) {
                    throw new NodeNotConnectedException(connection.getNode(), "connection already closed");
                }
                if (this.refs.tryIncRef()) {
                    this.toClose.add(connection);
                    this.refs.decRef();
                } else {
                    connection.sendRequest(requestId, action, request, options);
                }
            }

            @Override
            public void clearCallback() {
                this.refs.decRef();
            }

            private void closeConnections() {
                try {
                    IOUtils.close(this.toClose);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService, TimeValue duration) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress, duration);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress, TimeValue duration) {
        long startTimeInMillis = this.threadPool.relativeTimeInMillis();
        final Supplier<TimeValue> delaySupplier = () -> {
            long elapsed = this.threadPool.relativeTimeInMillis() - startTimeInMillis;
            return new TimeValue(Math.max(duration.millis() - elapsed, 0L));
        };
        this.transport().addConnectBehavior(transportAddress, new StubbableTransport.OpenConnectionBehavior(){
            private CountDownLatch stopLatch = new CountDownLatch(1);

            @Override
            public void openConnection(Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    MockTransportService.this.original.openConnection(discoveryNode, profile, listener);
                    return;
                }
                TimeValue connectingTimeout = (TimeValue)TransportSettings.CONNECT_TIMEOUT.getDefault(Settings.EMPTY);
                try {
                    if (delay.millis() < connectingTimeout.millis()) {
                        this.stopLatch.await(delay.millis(), TimeUnit.MILLISECONDS);
                        MockTransportService.this.original.openConnection(discoveryNode, profile, listener);
                    } else {
                        this.stopLatch.await(connectingTimeout.millis(), TimeUnit.MILLISECONDS);
                        listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                    }
                }
                catch (InterruptedException e) {
                    listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                }
            }

            @Override
            public void clearCallback() {
                this.stopLatch.countDown();
            }
        });
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(){
            private final Queue<Runnable> requestsToSendWhenCleared = new LinkedBlockingDeque<Runnable>();
            private boolean cleared = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRequest(final Transport.Connection connection, final long requestId, final String action, TransportRequest request, final TransportRequestOptions options) throws IOException {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    connection.sendRequest(requestId, action, request, options);
                    return;
                }
                BytesStreamOutput bStream = new BytesStreamOutput();
                request.writeTo((StreamOutput)bStream);
                RequestHandlerRegistry reg = MockTransportService.this.getRequestHandler(action);
                final TransportRequest clonedRequest = reg.newRequest(bStream.bytes().streamInput());
                assert (clonedRequest.getClass().equals(MasterNodeRequestHelper.unwrapTermOverride(request).getClass())) : String.valueOf(clonedRequest) + " vs " + String.valueOf(request);
                RunOnce runnable = new RunOnce((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        logger.debug(() -> Strings.format((String)"[%d][%s] failed to send delayed request to node [%s]", (Object[])new Object[]{requestId, action, connection.getNode()}), (Throwable)e);
                        MockTransportService.this.handleInternalSendException(action, connection.getNode(), requestId, null, e);
                    }

                    protected void doRun() throws IOException {
                        logger.debug(() -> Strings.format((String)"[%d][%s] sending delayed request to node [%s]", (Object[])new Object[]{requestId, action, connection.getNode()}));
                        connection.sendRequest(requestId, action, clonedRequest, options);
                    }
                });
                4 var12_11 = this;
                synchronized (var12_11) {
                    if (this.cleared) {
                        runnable.run();
                    } else {
                        this.requestsToSendWhenCleared.add((Runnable)runnable);
                        logger.debug(() -> Strings.format((String)"[%d][%s] delaying sending request to node [%s] by [%s]", (Object[])new Object[]{requestId, action, connection.getNode(), delay}));
                        MockTransportService.this.threadPool.schedule((Runnable)runnable, delay, (Executor)MockTransportService.this.testExecutor);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearCallback() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    assert (!this.cleared);
                    this.cleared = true;
                    this.requestsToSendWhenCleared.forEach(Runnable::run);
                }
            }
        });
    }

    public <R extends TransportRequest> void addRequestHandlingBehavior(String actionName, StubbableTransport.RequestHandlingBehavior<R> handlingBehavior) {
        this.transport().addRequestHandlingBehavior(actionName, handlingBehavior);
    }

    public boolean addSendBehavior(TransportService transportService, StubbableTransport.SendRequestBehavior sendBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addSendBehavior(transportAddress, sendBehavior);
        }
        return noRegistered;
    }

    public boolean addSendBehavior(TransportAddress transportAddress, StubbableTransport.SendRequestBehavior sendBehavior) {
        return this.transport().addSendBehavior(transportAddress, sendBehavior);
    }

    public boolean addSendBehavior(StubbableTransport.SendRequestBehavior behavior) {
        return this.transport().setDefaultSendBehavior(behavior);
    }

    public boolean addConnectBehavior(TransportService transportService, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addConnectBehavior(transportAddress, connectBehavior);
        }
        return noRegistered;
    }

    public boolean addConnectBehavior(TransportAddress transportAddress, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        return this.transport().addConnectBehavior(transportAddress, connectBehavior);
    }

    public boolean addGetConnectionBehavior(TransportAddress transportAddress, StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().addGetConnectionBehavior(transportAddress, behavior);
    }

    public boolean addGetConnectionBehavior(StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().setDefaultGetConnectionBehavior(behavior);
    }

    public boolean addNodeConnectedBehavior(StubbableConnectionManager.NodeConnectedBehavior behavior) {
        return this.connectionManager().setDefaultNodeConnectedBehavior(behavior);
    }

    public StubbableTransport transport() {
        return (StubbableTransport)this.transport;
    }

    public StubbableConnectionManager connectionManager() {
        return (StubbableConnectionManager)this.connectionManager;
    }

    public Transport getOriginalTransport() {
        StubbableTransport transport = this.transport();
        while (transport instanceof StubbableTransport) {
            transport = transport.getDelegate();
        }
        return transport;
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        super.openConnection(node, connectionProfile, listener.safeMap(connection -> {
            Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
            synchronized (map) {
                this.openConnections.computeIfAbsent(node, n -> new CopyOnWriteArrayList()).add(connection);
                connection.addCloseListener(ActionListener.running(() -> {
                    Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
                    synchronized (map) {
                        List<Transport.Connection> connections = this.openConnections.get(node);
                        boolean remove = connections.remove(connection);
                        assert (remove) : "Should have removed connection";
                        if (connections.isEmpty()) {
                            this.openConnections.remove(node);
                        }
                        if (this.openConnections.isEmpty()) {
                            this.openConnections.notifyAll();
                        }
                    }
                }));
            }
            return connection;
        }));
    }

    public void setOnConnectionClosedCallback(Consumer<Transport.Connection> callback) {
        this.onConnectionClosedCallback.set(callback);
    }

    public void onConnectionClosed(Transport.Connection connection) {
        Consumer<Transport.Connection> callback = this.onConnectionClosedCallback.get();
        if (callback != null) {
            callback.accept(connection);
        }
        super.onConnectionClosed(connection);
    }

    public void addOnStopListener(Runnable listener) {
        this.onStopListeners.add(listener);
    }

    protected void doStop() {
        this.onStopListeners.forEach(Runnable::run);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        super.doClose();
        try {
            Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
            synchronized (map) {
                if (!this.openConnections.isEmpty()) {
                    this.openConnections.wait(TimeUnit.SECONDS.toMillis(30L));
                }
                assert (this.openConnections.size() == 0) : "still open connections: " + String.valueOf(this.openConnections);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Assert.assertTrue((boolean)ThreadPool.terminate((ExecutorService)this.testExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    public void onRequestReceived(long requestId, String action) {
        super.onRequestReceived(requestId, action);
        this.messageListener.onRequestReceived(requestId, action);
    }

    public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
        super.onRequestSent(node, requestId, action, request, options);
        this.messageListener.onRequestSent(node, requestId, action, request, options);
    }

    public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
        super.onResponseReceived(requestId, holder);
        this.messageListener.onResponseReceived(requestId, holder);
    }

    public void onResponseSent(long requestId, String action) {
        super.onResponseSent(requestId, action);
        this.messageListener.onResponseSent(requestId, action);
    }

    public void onResponseSent(long requestId, String action, Exception e) {
        super.onResponseSent(requestId, action, e);
        this.messageListener.onResponseSent(requestId, action, e);
    }

    public void addMessageListener(TransportMessageListener listener) {
        this.messageListener.listeners.add(listener);
    }

    public void removeMessageListener(TransportMessageListener listener) {
        this.messageListener.listeners.remove(listener);
    }

    private static final class DelegatingTransportMessageListener
    implements TransportMessageListener {
        private final List<TransportMessageListener> listeners = new CopyOnWriteArrayList<TransportMessageListener>();

        private DelegatingTransportMessageListener() {
        }

        public void onRequestReceived(long requestId, String action) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestReceived(requestId, action);
            }
        }

        public void onResponseSent(long requestId, String action) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action);
            }
        }

        public void onResponseSent(long requestId, String action, Exception error) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action, error);
            }
        }

        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions finalOptions) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestSent(node, requestId, action, request, finalOptions);
            }
        }

        public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseReceived(requestId, holder);
            }
        }
    }

    public static class TestPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return List.of(MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING, MockTaskManager.SPY_TASK_MANAGER_SETTING);
        }
    }
}

