/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.time.TimeProvider;

public class AdvancingTimeProvider
implements TimeProvider {
    private final AtomicLong currentTimeMillis = new AtomicLong(System.currentTimeMillis());

    public void advanceByMillis(long milliseconds) {
        this.currentTimeMillis.addAndGet(milliseconds);
    }

    public long relativeTimeInMillis() {
        return this.currentTimeMillis.incrementAndGet();
    }

    public long relativeTimeInNanos() {
        return TimeUnit.NANOSECONDS.toNanos(this.relativeTimeInMillis());
    }

    public long rawRelativeTimeInMillis() {
        return this.relativeTimeInMillis();
    }

    public long absoluteTimeInMillis() {
        throw new UnsupportedOperationException("not supported");
    }
}

