/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.function.Function;
import shadow.fasterxml.jackson.core.JsonGenerator;
import shadow.fasterxml.jackson.core.JsonParser;
import shadow.org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import shadow.org.elasticsearch.xpack.sql.proto.ColumnInfo;
import shadow.org.elasticsearch.xpack.sql.proto.CoreProtocol;
import shadow.org.elasticsearch.xpack.sql.proto.MainResponse;
import shadow.org.elasticsearch.xpack.sql.proto.SqlClearCursorRequest;
import shadow.org.elasticsearch.xpack.sql.proto.SqlClearCursorResponse;
import shadow.org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import shadow.org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import shadow.org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import shadow.org.elasticsearch.xpack.sql.proto.content.AbstractObjectParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.ConstructingObjectParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.GeneratorUtils;
import shadow.org.elasticsearch.xpack.sql.proto.content.ParseException;
import shadow.org.elasticsearch.xpack.sql.proto.content.ParserUtils;
import shadow.org.elasticsearch.xpack.sql.proto.core.CheckedBiConsumer;
import shadow.org.elasticsearch.xpack.sql.proto.core.CheckedConsumer;
import shadow.org.elasticsearch.xpack.sql.proto.core.TimeValue;

public final class Payloads {
    private static final ConstructingObjectParser<MainResponse, Void> MAIN_RESPONSE_PARSER = new ConstructingObjectParser("sql/response/main_response", true, objects -> new MainResponse((String)objects[0], (String)objects[1], (String)objects[2], (String)objects[3]));
    private static final ConstructingObjectParser<ColumnInfo, Void> COLUMN_INFO_PARSER = new ConstructingObjectParser("sql/response/column_info", true, objects -> new ColumnInfo(objects[0] == null ? "" : (String)objects[0], (String)objects[1], (String)objects[2], (Integer)objects[3]));
    private static final ConstructingObjectParser<ColumnInfo, Void> ROWS_PARSER = new ConstructingObjectParser("sql/response/row", true, objects -> new ColumnInfo(objects[0] == null ? "" : (String)objects[0], (String)objects[1], (String)objects[2], (Integer)objects[3]));
    public static final ConstructingObjectParser<SqlQueryResponse, Void> QUERY_RESPONSE_PARSER = new ConstructingObjectParser("sql/response/query", true, objects -> new SqlQueryResponse(objects[0] == null ? "" : (String)objects[0], (List)objects[1], (List)objects[2], (String)objects[3], objects[4] != null && (Boolean)objects[4] != false, objects[5] != null && (Boolean)objects[5] != false));
    public static final ConstructingObjectParser<SqlClearCursorResponse, Void> CLEAR_CURSOR_PARSER = new ConstructingObjectParser("sql/response/clear_cursor", true, objects -> new SqlClearCursorResponse(objects[0] != null && (Boolean)objects[0] != false));

    private Payloads() {
    }

    public static MainResponse parseMainResponse(JsonParser parser) throws ParseException {
        return (MainResponse)MAIN_RESPONSE_PARSER.apply(parser, null);
    }

    public static SqlQueryResponse parseQueryResponse(JsonParser parser) throws ParseException {
        return (SqlQueryResponse)QUERY_RESPONSE_PARSER.apply(parser, null);
    }

    public static ColumnInfo parseColumnInfo(JsonParser parser) throws ParseException {
        return (ColumnInfo)COLUMN_INFO_PARSER.apply(parser, null);
    }

    public static SqlClearCursorResponse parseClearCursorResponse(JsonParser parser) throws ParseException {
        return (SqlClearCursorResponse)CLEAR_CURSOR_PARSER.apply(parser, null);
    }

    public static void generate(JsonGenerator generator, AbstractSqlRequest sqlRequest) throws IOException {
        if (sqlRequest instanceof SqlClearCursorRequest) {
            Payloads.generate(generator, (SqlClearCursorRequest)sqlRequest);
        } else if (sqlRequest instanceof SqlQueryRequest) {
            Payloads.generate(generator, (SqlQueryRequest)sqlRequest);
        }
    }

    public static void generate(JsonGenerator generator, ColumnInfo info) throws IOException {
        generator.writeStartObject();
        String table = info.table();
        if (table != null && !table.isEmpty()) {
            generator.writeStringField("table", table);
        }
        generator.writeStringField("name", info.name());
        generator.writeStringField("type", info.esType());
        if (info.displaySize() != null) {
            generator.writeNumberField("display_size", info.displaySize());
        }
        generator.writeEndObject();
    }

    public static void generate(JsonGenerator generator, SqlClearCursorRequest request) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("cursor", request.getCursor());
        generator.writeStringField("mode", request.mode().toString());
        Payloads.writeIfValid(generator, "client_id", request.clientId());
        Payloads.writeIfValidAsString(generator, "version", request.version());
        Payloads.writeIfValid(generator, "binary_format", request.binaryCommunication());
        generator.writeEndObject();
    }

    public static void generate(JsonGenerator generator, SqlTypedParamValue param) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", param.type);
        generator.writeFieldName("value");
        GeneratorUtils.unknownValue(generator, param.value);
        generator.writeEndObject();
    }

    public static void generate(JsonGenerator generator, SqlQueryRequest request) throws IOException {
        Payloads.generate(generator, request, Payloads::generate, null);
    }

    public static void generate(JsonGenerator generator, SqlQueryRequest request, CheckedBiConsumer<JsonGenerator, SqlTypedParamValue, IOException> sqlParamGenerator, CheckedConsumer<JsonGenerator, IOException> extraFields) throws IOException {
        generator.writeStartObject();
        Payloads.writeIfValid(generator, "query", request.query());
        generator.writeStringField("mode", request.mode().toString());
        Payloads.writeIfValid(generator, "client_id", request.clientId());
        Payloads.writeIfValidAsString(generator, "version", request.version());
        List<SqlTypedParamValue> params = request.params();
        if (params != null && !params.isEmpty()) {
            generator.writeArrayFieldStart("params");
            for (SqlTypedParamValue param : params) {
                sqlParamGenerator.accept(generator, param);
            }
            generator.writeEndArray();
        }
        Payloads.writeIfValidAsString(generator, "time_zone", request.zoneId(), ZoneId::getId);
        Payloads.writeIfValid(generator, "catalog", request.catalog());
        if (request.fetchSize() != 1000) {
            generator.writeNumberField("fetch_size", request.fetchSize());
        }
        if (request.requestTimeout() != CoreProtocol.REQUEST_TIMEOUT) {
            generator.writeStringField("request_timeout", request.requestTimeout().getStringRep());
        }
        if (request.pageTimeout() != CoreProtocol.PAGE_TIMEOUT) {
            generator.writeStringField("page_timeout", request.pageTimeout().getStringRep());
        }
        Payloads.writeIfValid(generator, "columnar", request.columnar());
        if (request.fieldMultiValueLeniency()) {
            generator.writeBooleanField("field_multi_value_leniency", request.fieldMultiValueLeniency());
        }
        if (request.indexIncludeFrozen()) {
            generator.writeBooleanField("index_include_frozen", request.indexIncludeFrozen());
        }
        Payloads.writeIfValid(generator, "binary_format", request.binaryCommunication());
        Payloads.writeIfValid(generator, "cursor", request.cursor());
        Payloads.writeIfValidAsString(generator, "wait_for_completion_timeout", request.waitForCompletionTimeout(), TimeValue::getStringRep);
        if (request.keepOnCompletion()) {
            generator.writeBooleanField("keep_on_completion", request.keepOnCompletion());
        }
        Payloads.writeIfValidAsString(generator, "keep_alive", request.keepAlive(), TimeValue::getStringRep);
        if (request.allowPartialSearchResults()) {
            generator.writeBooleanField("allow_partial_search_results", request.allowPartialSearchResults());
        }
        if (request.projectRouting() != null) {
            generator.writeStringField("project_routing", request.projectRouting());
        }
        if (extraFields != null) {
            extraFields.accept(generator);
        }
        generator.writeEndObject();
    }

    private static void writeIfValid(JsonGenerator generator, String name, String value) throws IOException {
        if (value != null) {
            generator.writeStringField(name, value);
        }
    }

    private static void writeIfValid(JsonGenerator generator, String name, Boolean value) throws IOException {
        if (value != null) {
            generator.writeBooleanField(name, value);
        }
    }

    private static void writeIfValidAsString(JsonGenerator generator, String name, Object value) throws IOException {
        Payloads.writeIfValidAsString(generator, name, value, Object::toString);
    }

    private static <T> void writeIfValidAsString(JsonGenerator generator, String name, T value, Function<T, String> toString) throws IOException {
        if (value != null) {
            generator.writeStringField(name, toString.apply(value));
        }
    }

    static {
        MAIN_RESPONSE_PARSER.declareString(ConstructingObjectParser.constructorArg(), "name");
        MAIN_RESPONSE_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ParserUtils.map(p).get("number"), "version");
        MAIN_RESPONSE_PARSER.declareString(ConstructingObjectParser.constructorArg(), "cluster_name");
        MAIN_RESPONSE_PARSER.declareString(ConstructingObjectParser.constructorArg(), "cluster_uuid");
        MAIN_RESPONSE_PARSER.declareString((response, value) -> {}, "tagline");
        COLUMN_INFO_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), "table");
        COLUMN_INFO_PARSER.declareString(ConstructingObjectParser.constructorArg(), "name");
        COLUMN_INFO_PARSER.declareString(ConstructingObjectParser.constructorArg(), "type");
        COLUMN_INFO_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), "display_size");
        QUERY_RESPONSE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), "cursor");
        QUERY_RESPONSE_PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Payloads.parseColumnInfo(p), "columns");
        QUERY_RESPONSE_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ParserUtils.list(p), "rows", AbstractObjectParser.ValueType.OBJECT_ARRAY);
        QUERY_RESPONSE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), "id");
        QUERY_RESPONSE_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), "is_partial");
        QUERY_RESPONSE_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), "is_running");
        CLEAR_CURSOR_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), "succeeded");
    }
}

