/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import shadow.org.elasticsearch.xpack.sql.client.ClientException;
import shadow.org.elasticsearch.xpack.sql.client.StringUtils;
import shadow.org.elasticsearch.xpack.sql.client.SuppressForbidden;

class ProxyConfig {
    private static final String HTTP_PROXY = "proxy.http";
    private static final String HTTP_PROXY_DEFAULT = "";
    private static final String SOCKS_PROXY = "proxy.socks";
    private static final String SOCKS_PROXY_DEFAULT = "";
    static final Set<String> OPTION_NAMES = new LinkedHashSet<String>(Arrays.asList("proxy.http", "proxy.socks"));
    private final Proxy proxy;

    ProxyConfig(Properties settings) {
        Proxy.Type type = null;
        Object[] address = ProxyConfig.host(settings.getProperty(HTTP_PROXY, ""), 80);
        type = Proxy.Type.HTTP;
        if (address == null) {
            address = ProxyConfig.host(settings.getProperty(SOCKS_PROXY, ""), 1080);
            type = Proxy.Type.SOCKS;
        }
        this.proxy = address != null ? ProxyConfig.createProxy(type, address) : null;
    }

    @SuppressForbidden(reason="create the actual proxy")
    private static Proxy createProxy(Proxy.Type type, Object[] address) {
        return new Proxy(type, new InetSocketAddress((String)address[0], (int)((Integer)address[1])));
    }

    boolean enabled() {
        return this.proxy != null;
    }

    Proxy proxy() {
        return this.proxy;
    }

    private static Object[] host(String address, int defaultPort) {
        if (!StringUtils.hasText(address)) {
            return null;
        }
        try {
            URI uri = new URI(address);
            Object[] results = new Object[]{uri.getHost(), uri.getPort() > 0 ? uri.getPort() : defaultPort};
            return results;
        }
        catch (URISyntaxException ex) {
            throw new ClientException("Unrecognized address format " + address, ex);
        }
    }
}

