/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public record RemoteIndicesPermission(List<RemoteIndicesGroup> remoteIndicesGroups) {
    public static final RemoteIndicesPermission NONE = new RemoteIndicesPermission(List.of());

    public RemoteIndicesPermission forCluster(String remoteClusterAlias) {
        return new RemoteIndicesPermission(this.remoteIndicesGroups.stream().filter(remoteIndicesGroup -> remoteIndicesGroup.checkRemoteClusterAlias(remoteClusterAlias)).toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final Map<Set<String>, List<IndicesPermission.Group>> remoteIndicesGroups = new HashMap<Set<String>, List<IndicesPermission.Group>>();

        public Builder addGroup(Set<String> remoteClusterAliases, IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            assert (query == null || query.size() <= 1) : "remote indices groups only support up to one DLS query";
            assert (fieldPermissions.getFieldPermissionsDefinitions().stream().noneMatch(groups -> groups.getFieldGrantExcludeGroups().size() > 1)) : "remote indices groups only support up to one FLS field-grant-exclude group";
            this.remoteIndicesGroups.computeIfAbsent(remoteClusterAliases, k -> new ArrayList()).add(new IndicesPermission.Group(privilege, fieldPermissions, query, allowRestrictedIndices, new RestrictedIndices(Automatons.EMPTY), indices));
            return this;
        }

        public RemoteIndicesPermission build() {
            return new RemoteIndicesPermission(this.remoteIndicesGroups.entrySet().stream().map(entry -> new RemoteIndicesGroup((Set)entry.getKey(), (List)entry.getValue())).toList());
        }
    }

    public record RemoteIndicesGroup(Set<String> remoteClusterAliases, StringMatcher remoteClusterAliasMatcher, List<IndicesPermission.Group> indicesPermissionGroups) {
        public RemoteIndicesGroup(Set<String> remoteClusterAliases, List<IndicesPermission.Group> indicesPermissionGroups) {
            this(remoteClusterAliases, StringMatcher.of(remoteClusterAliases), indicesPermissionGroups);
        }

        public boolean checkRemoteClusterAlias(String remoteClusterAlias) {
            return this.remoteClusterAliasMatcher.test(remoteClusterAlias);
        }
    }
}

