/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.time.DateTimeFormatterTimestampConverter;

public class DataDescription
implements ToXContentObject,
Writeable {
    public static final ParseField DATA_DESCRIPTION_FIELD = new ParseField("data_description", new String[0]);
    public static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    public static final ParseField TIME_FIELD_NAME_FIELD = new ParseField("time_field", new String[0]);
    public static final ParseField TIME_FORMAT_FIELD = new ParseField("time_format", new String[0]);
    public static final String EPOCH = "epoch";
    public static final String EPOCH_MS = "epoch_ms";
    public static final String DEFAULT_TIME_FIELD = "time";
    private final String timeFieldName;
    private final String timeFormat;
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = DataDescription.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = DataDescription.createParser(false);

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(DATA_DESCRIPTION_FIELD.getPreferredName(), ignoreUnknownFields, Builder::new);
        if (!ignoreUnknownFields) {
            parser.declareString((builder, format) -> DataFormat.forString(format), FORMAT_FIELD);
        }
        parser.declareString(Builder::setTimeField, TIME_FIELD_NAME_FIELD);
        parser.declareString(Builder::setTimeFormat, TIME_FORMAT_FIELD);
        return parser;
    }

    public DataDescription(String timeFieldName, String timeFormat) {
        this.timeFieldName = timeFieldName;
        this.timeFormat = timeFormat;
    }

    public DataDescription(StreamInput in) throws IOException {
        this.timeFieldName = in.readString();
        this.timeFormat = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.timeFieldName);
        out.writeString(this.timeFormat);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIME_FIELD_NAME_FIELD.getPreferredName(), this.timeFieldName);
        builder.field(TIME_FORMAT_FIELD.getPreferredName(), this.timeFormat);
        builder.endObject();
        return builder;
    }

    public String getTimeField() {
        return this.timeFieldName;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public boolean isTransformTime() {
        return this.timeFormat != null && !EPOCH.equals(this.timeFormat);
    }

    public boolean isEpochMs() {
        return EPOCH_MS.equals(this.timeFormat);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataDescription)) {
            return false;
        }
        DataDescription that = (DataDescription)other;
        return Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.timeFormat, that.timeFormat);
    }

    public int hashCode() {
        return Objects.hash(this.timeFieldName, this.timeFormat);
    }

    public static enum DataFormat implements Writeable
    {
        XCONTENT;

        private static final String REMOVED_DELIMITED = "DELIMITED";

        public static DataFormat forString(String value) {
            String valueUpperCase = value.toUpperCase(Locale.ROOT);
            return REMOVED_DELIMITED.equals(valueUpperCase) ? XCONTENT : DataFormat.valueOf(valueUpperCase);
        }

        public static DataFormat readFromStream(StreamInput in) {
            try {
                return (DataFormat)in.readEnum(DataFormat.class);
            }
            catch (IOException e) {
                return XCONTENT;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String timeFieldName = "time";
        private String timeFormat = "epoch_ms";

        public Builder setTimeField(String fieldName) {
            this.timeFieldName = ExceptionsHelper.requireNonNull(fieldName, TIME_FIELD_NAME_FIELD.getPreferredName() + " must not be null");
            return this;
        }

        public Builder setTimeFormat(String format) {
            ExceptionsHelper.requireNonNull(format, TIME_FORMAT_FIELD.getPreferredName() + " must not be null");
            switch (format) {
                case "epoch": 
                case "epoch_ms": {
                    break;
                }
                default: {
                    try {
                        DateTimeFormatterTimestampConverter.ofPattern(format, ZoneOffset.UTC);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid Time format string ''{0}''", format), e.getCause(), new Object[0]);
                    }
                }
            }
            this.timeFormat = format;
            return this;
        }

        public DataDescription build() {
            return new DataDescription(this.timeFieldName, this.timeFormat);
        }
    }
}

