/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public class TDigestHolder {
    private final double min;
    private final double max;
    private final double sum;
    private final long valueCount;
    private final BytesRef encodedDigest;

    public TDigestHolder(BytesRef encodedDigest, double min, double max, double sum, long valueCount) {
        this.encodedDigest = encodedDigest;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.valueCount = valueCount;
    }

    public TDigestHolder(List<Double> centroids, List<Long> counts, double min, double max, double sum, long valueCount) throws IOException {
        this(TDigestHolder.encodeCentroidsAndCounts(centroids, counts), min, max, sum, valueCount);
    }

    public boolean equals(Object o) {
        if (o instanceof TDigestHolder) {
            TDigestHolder that = (TDigestHolder)o;
            return Double.compare(this.min, that.min) == 0 && Double.compare(this.max, that.max) == 0 && Double.compare(this.sum, that.sum) == 0 && this.valueCount == that.valueCount && Objects.equals(this.encodedDigest, that.encodedDigest);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.sum, this.valueCount, this.encodedDigest);
    }

    private static BytesRef encodeCentroidsAndCounts(List<Double> centroids, List<Long> counts) throws IOException {
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        for (int i = 0; i < centroids.size(); ++i) {
            long count = counts.get(i);
            assert (count >= 0L);
            if (count <= 0L) continue;
            streamOutput.writeVLong(count);
            streamOutput.writeDouble(centroids.get(i).doubleValue());
        }
        BytesRef docValue = streamOutput.bytes().toBytesRef();
        return docValue;
    }

    public BytesRef getEncodedDigest() {
        return this.encodedDigest;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getSum() {
        return this.sum;
    }

    public long getValueCount() {
        return this.valueCount;
    }
}

