/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongDoubleAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopLongDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongDoubleAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopLongDoubleAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopLongDoubleAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopLongDoubleGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopLongDoubleAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongDoubleAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopLongDoubleGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongDoubleGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_long of doubles";
    }
}

