/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AllLastIntByTimestampAggregator;
import org.elasticsearch.compute.aggregation.AllLongIntState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class AllLastIntByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.INT), new IntermediateStateDesc("seen", ElementType.BOOLEAN), new IntermediateStateDesc("hasValue", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final AllLongIntState state;
    private final List<Integer> channels;

    public AllLastIntByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, AllLongIntState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static AllLastIntByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new AllLastIntByTimestampAggregatorFunction(driverContext, channels, AllLastIntByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock);
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            AllLastIntByTimestampAggregator.combine(this.state, p, valueBlock, timestampBlock);
        }
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p)) continue;
            AllLastIntByTimestampAggregator.combine(this.state, p, valueBlock, timestampBlock);
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + AllLastIntByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        IntVector values = ((IntBlock)valuesUncast).asVector();
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        Object hasValueUncast = page.getBlock(this.channels.get(3));
        if (hasValueUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector hasValue = ((BooleanBlock)hasValueUncast).asVector();
        assert (hasValue.getPositionCount() == 1);
        AllLastIntByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getInt(0), seen.getBoolean(0), hasValue.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = AllLastIntByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

