/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;

public interface SupportedVersion {
    public static final SupportedVersion SUPPORTED_ON_ALL_NODES;

    public boolean supportedOn(TransportVersion var1, boolean var2);

    default public boolean supportedLocally() {
        return this.supportedOn(TransportVersion.current(), Build.current().isSnapshot());
    }

    default public boolean underConstruction() {
        return false;
    }

    public static SupportedVersion underConstruction(final TransportVersion createdVersion) {
        return new SupportedVersion(){

            @Override
            public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
                return currentBuildIsSnapshot && version.supports(createdVersion);
            }

            public String toString() {
                return "UnderConstruction";
            }

            @Override
            public boolean underConstruction() {
                return true;
            }
        };
    }

    public static SupportedVersion supportedSince(final TransportVersion createdVersion, final TransportVersion supportedVersion) {
        if (!4.$assertionsDisabled && !supportedVersion.onOrAfter((VersionId)createdVersion)) {
            throw new AssertionError((Object)"support for a type cannot be enabled before its initial creation");
        }
        return new SupportedVersion(){

            @Override
            public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
                return currentBuildIsSnapshot ? version.supports(createdVersion) : version.supports(supportedVersion);
            }

            public String toString() {
                return "SupportedOn[" + String.valueOf(supportedVersion) + "]";
            }
        };
    }

    static {
        if (4.$assertionsDisabled) {
            // empty if block
        }
        SUPPORTED_ON_ALL_NODES = new SupportedVersion(){

            @Override
            public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
                return true;
            }

            public String toString() {
                return "SupportedOnAllVersions";
            }
        };
    }
}

