/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class PlannerSettings {
    public static final Setting<DataPartitioning> DEFAULT_DATA_PARTITIONING = Setting.enumSetting(DataPartitioning.class, (String)"esql.default_data_partitioning", (Enum)DataPartitioning.AUTO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<ByteSizeValue> VALUES_LOADING_JUMBO_SIZE = new Setting("esql.values_loading_jumbo_size", settings -> {
        long proportional = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 1024L;
        return ByteSizeValue.ofBytes((long)Math.max(proportional, ByteSizeValue.ofMb((long)1L).getBytes())).getStringRep();
    }, s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio((String)s, (String)"esql.values_loading_jumbo_size"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> LUCENE_TOPN_LIMIT = Setting.intSetting((String)"esql.lucene_topn_limit", (int)((Integer)IndexSettings.MAX_RESULT_WINDOW_SETTING.getDefault(Settings.EMPTY)), (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<ByteSizeValue> INTERMEDIATE_LOCAL_RELATION_MAX_SIZE = Setting.memorySizeSetting((String)"esql.intermediate_local_relation_max_size", (String)"0.1%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> REDUCTION_LATE_MATERIALIZATION = Setting.boolSetting((String)"esql.reduction_late_materialization", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile DataPartitioning defaultDataPartitioning;
    private volatile ByteSizeValue valuesLoadingJumboSize;
    private volatile int luceneTopNLimit;
    private volatile ByteSizeValue intermediateLocalRelationMaxSize;

    public PlannerSettings(ClusterService clusterService) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.initializeAndWatch(DEFAULT_DATA_PARTITIONING, v -> {
            this.defaultDataPartitioning = v;
        });
        clusterSettings.initializeAndWatch(VALUES_LOADING_JUMBO_SIZE, v -> {
            this.valuesLoadingJumboSize = v;
        });
        clusterSettings.initializeAndWatch(LUCENE_TOPN_LIMIT, v -> {
            this.luceneTopNLimit = v;
        });
        clusterSettings.initializeAndWatch(INTERMEDIATE_LOCAL_RELATION_MAX_SIZE, v -> {
            this.intermediateLocalRelationMaxSize = v;
        });
    }

    public PlannerSettings(DataPartitioning defaultDataPartitioning, ByteSizeValue valuesLoadingJumboSize, int luceneTopNLimit, ByteSizeValue intermediateLocalRelationMaxSize) {
        this.defaultDataPartitioning = defaultDataPartitioning;
        this.valuesLoadingJumboSize = valuesLoadingJumboSize;
        this.luceneTopNLimit = luceneTopNLimit;
        this.intermediateLocalRelationMaxSize = intermediateLocalRelationMaxSize;
    }

    public DataPartitioning defaultDataPartitioning() {
        return this.defaultDataPartitioning;
    }

    public ByteSizeValue valuesLoadingJumboSize() {
        return this.valuesLoadingJumboSize;
    }

    public int luceneTopNLimit() {
        return this.luceneTopNLimit;
    }

    public ByteSizeValue intermediateLocalRelationMaxSize() {
        return this.intermediateLocalRelationMaxSize;
    }
}

