/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.time.Duration;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class Evaluation {
    public static final Evaluation NONE = new Evaluation(new Literal(Source.EMPTY, (Object)Duration.ZERO, DataType.TIME_DURATION), false, Literal.NULL);
    private final Literal offset;
    private final boolean offsetNegative;
    private final Literal at;

    public Evaluation(Literal offset, boolean offsetNegative, Literal at) {
        this.offset = offset;
        this.offsetNegative = offsetNegative;
        this.at = at;
    }

    public Literal offset() {
        return this.offset;
    }

    public Duration offsetDuration() {
        return (Duration)this.offset.value();
    }

    public boolean offsetNegative() {
        return this.offsetNegative;
    }

    public Literal at() {
        return this.at;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Evaluation that = (Evaluation)o;
        return this.offsetNegative == that.offsetNegative && Objects.equals(this.offset, that.offset) && Objects.equals(this.at, that.at);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.offsetNegative, this.at);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.offset != null && !this.offsetDuration().isZero()) {
            sb.append("offset ");
            if (this.offsetNegative) {
                sb.append("-");
            }
            sb.append(this.offset);
        }
        if (this.at != null) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append("@ ").append(this.at);
        }
        return sb.toString();
    }
}

