/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlFunctionCall;

public class AcrossSeriesAggregate
extends PromqlFunctionCall {
    private final Grouping grouping;
    private final List<NamedExpression> groupings;

    public AcrossSeriesAggregate(Source source, LogicalPlan child, String functionName, List<Expression> parameters, Grouping grouping, List<NamedExpression> groupings) {
        super(source, child, functionName, parameters);
        this.grouping = grouping;
        this.groupings = groupings;
    }

    public Grouping grouping() {
        return this.grouping;
    }

    public List<NamedExpression> groupings() {
        return this.groupings;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && super.expressionsResolved();
    }

    @Override
    protected NodeInfo<PromqlFunctionCall> info() {
        return NodeInfo.create((Node)this, AcrossSeriesAggregate::new, (Object)((Object)this.child()), (Object)this.functionName(), this.parameters(), (Object)((Object)this.grouping()), this.groupings());
    }

    @Override
    public AcrossSeriesAggregate replaceChild(LogicalPlan newChild) {
        return new AcrossSeriesAggregate(this.source(), newChild, this.functionName(), this.parameters(), this.grouping(), this.groupings());
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            AcrossSeriesAggregate that = (AcrossSeriesAggregate)((Object)o);
            return this.grouping == that.grouping && Objects.equals(this.groupings, that.groupings);
        }
        return false;
    }

    @Override
    public List<Attribute> output() {
        ArrayList<Attribute> output = new ArrayList<Attribute>(this.groupings.size());
        for (NamedExpression exp : this.groupings) {
            output.add(exp.toAttribute());
        }
        return output;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.grouping, this.groupings});
    }

    public static enum Grouping {
        BY,
        WITHOUT,
        NONE;

    }
}

