/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePatternList;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPatternList;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.DateUtils;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.FilteredExpression;
import org.elasticsearch.xpack.esql.expression.function.fulltext.MatchOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RLike;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RLikeList;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RegexMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.WildcardLike;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.WildcardLikeList;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.QueryParam;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class ExpressionBuilder
extends IdentifierBuilder {
    private int expressionDepth = 0;
    public static final int MAX_EXPRESSION_DEPTH = 400;
    protected final ParsingContext context;
    private static String INVALID_WILDCARD = "invalid_wildcard";
    private static String INVALID_REGEX = "invalid_regex";

    ExpressionBuilder(ParsingContext context) {
        this.context = context;
    }

    protected Expression expression(ParseTree ctx) {
        ++this.expressionDepth;
        if (this.expressionDepth > 400) {
            throw new ParsingException("ESQL statement exceeded the maximum expression depth allowed ({}): [{}]", 400, ctx.getParent().getText());
        }
        try {
            Expression expression = ParserUtils.typedParsing(this, ctx, Expression.class);
            return expression;
        }
        finally {
            --this.expressionDepth;
        }
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return ParserUtils.visitList(this, contexts, Expression.class);
    }

    protected static ParsingException qualifiersUnsupportedInFieldDefinitions(Source source, String qualifiedName) {
        return new ParsingException(source, "Qualified names are not supported in field definitions, found [{}]", qualifiedName);
    }

    protected static ParsingException qualifiersUnsupportedInPatterns(Source source, String qualifiedNamePattern) {
        return new ParsingException(source, "Qualified names are not supported in patterns, found [{}]", qualifiedNamePattern);
    }

    @Override
    public Literal visitBooleanValue(EsqlBaseParser.BooleanValueContext ctx) {
        Source source = ParserUtils.source(ctx);
        return new Literal(source, (Object)(ctx.TRUE() != null ? 1 : 0), DataType.BOOLEAN);
    }

    @Override
    public Literal visitDecimalValue(EsqlBaseParser.DecimalValueContext ctx) {
        Source source = ParserUtils.source(ctx);
        String text = ctx.getText();
        try {
            return new Literal(source, (Object)StringUtils.parseDouble((String)text), DataType.DOUBLE);
        }
        catch (InvalidArgumentException iae) {
            throw new ParsingException(source, iae.getMessage(), new Object[0]);
        }
    }

    @Override
    public Literal visitIntegerValue(EsqlBaseParser.IntegerValueContext ctx) {
        DataType type;
        Number val;
        Number number;
        Source source = ParserUtils.source(ctx);
        String text = ctx.getText();
        try {
            number = EsqlDataTypeConverter.stringToIntegral(text);
        }
        catch (InvalidArgumentException siae) {
            try {
                return new Literal(source, (Object)EsqlDataTypeConverter.stringToDouble(text), DataType.DOUBLE);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                throw new ParsingException(source, siae.getMessage(), new Object[0]);
            }
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            val = NumericUtils.asLongUnsigned((BigInteger)bi);
            type = DataType.UNSIGNED_LONG;
        } else if ((long)number.intValue() == number.longValue()) {
            val = number.intValue();
            type = DataType.INTEGER;
        } else {
            val = number.longValue();
            type = DataType.LONG;
        }
        return new Literal(source, (Object)val, type);
    }

    @Override
    public Object visitNumericArrayLiteral(EsqlBaseParser.NumericArrayLiteralContext ctx) {
        Source source = ParserUtils.source(ctx);
        List<Literal> numbers = ParserUtils.visitList(this, ctx.numericValue(), Literal.class);
        if (numbers.stream().anyMatch(l -> l.dataType() == DataType.DOUBLE)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.doubleValue()), DataType.DOUBLE);
        }
        if (numbers.stream().anyMatch(l -> l.dataType() == DataType.UNSIGNED_LONG)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> dt == DataType.UNSIGNED_LONG ? no.longValue() : EsqlDataTypeConverter.bigIntegerToUnsignedLong(BigInteger.valueOf(no.longValue()))), DataType.UNSIGNED_LONG);
        }
        if (numbers.stream().anyMatch(l -> l.dataType() == DataType.LONG)) {
            return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.longValue()), DataType.LONG);
        }
        return new Literal(source, this.mapNumbers(numbers, (no, dt) -> no.intValue()), DataType.INTEGER);
    }

    private List<Object> mapNumbers(List<Literal> numbers, BiFunction<Number, DataType, Object> map) {
        return numbers.stream().map(l -> map.apply((Number)l.value(), l.dataType())).toList();
    }

    @Override
    public Object visitBooleanArrayLiteral(EsqlBaseParser.BooleanArrayLiteralContext ctx) {
        return this.visitArrayLiteral(ctx, ctx.booleanValue(), DataType.BOOLEAN);
    }

    @Override
    public Object visitStringArrayLiteral(EsqlBaseParser.StringArrayLiteralContext ctx) {
        return this.visitArrayLiteral(ctx, ctx.string(), DataType.KEYWORD);
    }

    private Object visitArrayLiteral(ParserRuleContext ctx, List<? extends ParserRuleContext> contexts, DataType dataType) {
        Source source = ParserUtils.source(ctx);
        List<Literal> literals = ParserUtils.visitList(this, contexts, Literal.class);
        return new Literal(source, literals.stream().map(Literal::value).toList(), dataType);
    }

    @Override
    public Literal visitNullLiteral(EsqlBaseParser.NullLiteralContext ctx) {
        Source source = ParserUtils.source(ctx);
        return new Literal(source, null, DataType.NULL);
    }

    @Override
    public Literal visitStringLiteral(EsqlBaseParser.StringLiteralContext ctx) {
        return this.visitString(ctx.string());
    }

    @Override
    public Literal visitString(EsqlBaseParser.StringContext ctx) {
        Source source = ParserUtils.source(ctx);
        return Literal.keyword((Source)source, (String)ExpressionBuilder.unquote(source));
    }

    @Override
    public UnresolvedAttribute visitQualifiedName(EsqlBaseParser.QualifiedNameContext ctx) {
        return this.visitQualifiedName(ctx, null);
    }

    public UnresolvedAttribute visitQualifiedName(EsqlBaseParser.QualifiedNameContext ctx, UnresolvedAttribute defaultValue) {
        if (ctx == null) {
            return defaultValue;
        }
        String name = this.visitFieldName(ctx.fieldName());
        String qualifier = ctx.qualifier != null ? ctx.qualifier.getText() : null;
        return new UnresolvedAttribute(ParserUtils.source(ctx), qualifier, name, null);
    }

    @Override
    public String visitFieldName(EsqlBaseParser.FieldNameContext ctx) {
        List<Object> items = ParserUtils.visitList(this, ctx.identifierOrParameter(), Object.class);
        ArrayList<String> strings = new ArrayList<String>(items.size());
        for (Object item : items) {
            if (item instanceof String) {
                String s = (String)item;
                strings.add(s);
                continue;
            }
            if (!(item instanceof Expression)) continue;
            Expression e = (Expression)item;
            strings.add(this.unresolvedAttributeNameInParam(ctx, e));
        }
        return Strings.collectionToDelimitedString(strings, (String)".");
    }

    @Override
    public List<NamedExpression> visitQualifiedNamePatterns(EsqlBaseParser.QualifiedNamePatternsContext ctx) {
        return this.visitQualifiedNamePatterns(ctx, ne -> {});
    }

    protected List<NamedExpression> visitQualifiedNamePatterns(EsqlBaseParser.QualifiedNamePatternsContext ctx, Consumer<NamedExpression> checker) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        List<EsqlBaseParser.QualifiedNamePatternContext> identifiers = ctx.qualifiedNamePattern();
        ArrayList<NamedExpression> names = new ArrayList<NamedExpression>(identifiers.size());
        for (EsqlBaseParser.QualifiedNamePatternContext patternContext : identifiers) {
            names.add(this.visitQualifiedNamePattern(patternContext, checker));
        }
        return names;
    }

    protected NamedExpression visitQualifiedNamePattern(EsqlBaseParser.QualifiedNamePatternContext patternContext, Consumer<NamedExpression> checker) {
        NamedExpression ne = this.visitQualifiedNamePattern(patternContext);
        checker.accept(ne);
        return ne;
    }

    @Override
    public NamedExpression visitQualifiedNamePattern(EsqlBaseParser.QualifiedNamePatternContext qualifiedCtx) {
        Object result;
        String qualifier;
        if (qualifiedCtx == null) {
            return null;
        }
        String string = qualifier = qualifiedCtx.qualifier != null ? qualifiedCtx.qualifier.getText() : null;
        if (qualifier != null && qualifier.charAt(0) == '`') {
            throw new ParsingException(ParserUtils.source(qualifiedCtx), "Quoted identifiers are not supported as qualifiers, found [{}]", qualifier);
        }
        EsqlBaseParser.FieldNamePatternContext unqualifiedCtx = qualifiedCtx.fieldNamePattern();
        Source src = ParserUtils.source(qualifiedCtx);
        StringBuilder patternString = new StringBuilder();
        StringBuilder nameString = new StringBuilder();
        List<EsqlBaseParser.IdentifierPatternContext> patterns = unqualifiedCtx.identifierPattern();
        if (patterns.size() == 1) {
            EsqlBaseParser.IdentifierPatternContext idCtx = patterns.get(0);
            boolean unresolvedStar = false;
            if (idCtx.ID_PATTERN() != null && idCtx.ID_PATTERN().getText().equals("*")) {
                unresolvedStar = true;
            }
            if (idCtx.parameter() != null || idCtx.doubleParameter() != null) {
                UnresolvedNamePattern up;
                EsqlBaseParser.ParameterContext paramCtx = idCtx.parameter();
                EsqlBaseParser.DoubleParameterContext doubleParamsCtx = idCtx.doubleParameter();
                Expression exp = this.expression((ParseTree)(paramCtx != null ? paramCtx : doubleParamsCtx));
                if (exp instanceof Literal) {
                    Literal literal = (Literal)exp;
                    if (literal.value() != null) {
                        throw new ParsingException(src, "Query parameter [{}] with value [{}] declared as a constant, cannot be used as an identifier or pattern", unqualifiedCtx.getText(), literal);
                    }
                } else if (exp instanceof UnresolvedNamePattern && (up = (UnresolvedNamePattern)exp).name() != null && up.name().equals("*")) {
                    unresolvedStar = true;
                }
            }
            if (unresolvedStar) {
                if (qualifier != null) {
                    throw ExpressionBuilder.qualifiersUnsupportedInPatterns(src, qualifiedCtx.getText());
                }
                return new UnresolvedStar(src, null);
            }
        }
        boolean hasPattern = false;
        ArrayList<String> objects = new ArrayList<String>(patterns.size());
        int s = patterns.size();
        for (int i = 0; i < s; ++i) {
            if (i > 0) {
                patternString.append(".");
                nameString.append(".");
                objects.add(".");
            }
            Object patternContext = "";
            EsqlBaseParser.IdentifierPatternContext identifierPatternContext = patterns.get(i);
            if (identifierPatternContext.ID_PATTERN() != null) {
                patternContext = identifierPatternContext.ID_PATTERN().getText();
            } else if (identifierPatternContext.parameter() != null || identifierPatternContext.doubleParameter() != null) {
                EsqlBaseParser.ParameterContext paramCtx = identifierPatternContext.parameter();
                EsqlBaseParser.DoubleParameterContext doubleParamsCtx = identifierPatternContext.doubleParameter();
                Expression exp = this.expression((ParseTree)(paramCtx != null ? paramCtx : doubleParamsCtx));
                if (exp instanceof Literal) {
                    Literal lit = (Literal)exp;
                    if (lit.value() != null) {
                        throw new ParsingException(src, "Constant [{}] is unsupported for [{}]", new Object[]{identifierPatternContext, unqualifiedCtx.getText()});
                    }
                } else {
                    if (exp instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ua = (UnresolvedAttribute)exp;
                        String unquotedIdentifier = ua.name();
                        String quotedIdentifier = ExpressionBuilder.quoteIdString(unquotedIdentifier);
                        patternString.append(quotedIdentifier);
                        objects.add(unquotedIdentifier);
                        nameString.append(unquotedIdentifier);
                        continue;
                    }
                    if (exp instanceof UnresolvedNamePattern) {
                        UnresolvedNamePattern up = (UnresolvedNamePattern)exp;
                        patternContext = up.name();
                    }
                }
            } else {
                throw new ParsingException(src, "Unsupported field name pattern [{}]", new Object[]{identifierPatternContext});
            }
            if (((String)patternContext).isEmpty()) continue;
            List<String> fragments = ExpressionBuilder.breakIntoFragments((String)patternContext);
            for (String fragment : fragments) {
                if (!(fragment.charAt(0) == '`')) {
                    patternString.append(fragment);
                    nameString.append(fragment);
                    if (Regex.isSimpleMatchPattern((String)fragment)) {
                        hasPattern = true;
                        String str = fragment;
                        boolean keepGoing = false;
                        do {
                            int localIndex;
                            if ((localIndex = str.indexOf(42)) != -1) {
                                keepGoing = true;
                                if (localIndex > 0) {
                                    objects.add(str.substring(0, localIndex));
                                }
                                objects.add((String)Automata.makeAnyString());
                                if (++localIndex < str.length()) {
                                    str = str.substring(localIndex);
                                    continue;
                                }
                                keepGoing = false;
                                continue;
                            }
                            keepGoing = false;
                            if (str.length() <= 0) continue;
                            objects.add(str);
                        } while (keepGoing);
                        continue;
                    }
                    objects.add(fragment);
                    continue;
                }
                patternString.append(fragment);
                String unquotedString = ExpressionBuilder.unquoteIdString(fragment);
                objects.add(unquotedString);
                nameString.append(unquotedString);
            }
        }
        if (hasPattern) {
            ArrayList<Automaton> list = new ArrayList<Automaton>(objects.size());
            for (Object e : objects) {
                Automaton a;
                list.add(e instanceof Automaton ? (a = (Automaton)e) : Automata.makeString((String)e.toString()));
            }
            try {
                result = new UnresolvedNamePattern(src, new CharacterRunAutomaton(Operations.determinize((Automaton)Operations.concatenate(list), (int)10000)), patternString.toString(), nameString.toString());
            }
            catch (TooComplexToDeterminizeException e) {
                throw new ParsingException("Pattern was too complex to determinize", new Object[]{e});
            }
            if (qualifier != null) {
                throw ExpressionBuilder.qualifiersUnsupportedInPatterns(src, qualifiedCtx.getText());
            }
        } else {
            result = new UnresolvedAttribute(src, qualifier, Strings.collectionToDelimitedString(objects, (String)""), null);
            if (qualifier != null && qualifier.contains("*")) {
                throw ExpressionBuilder.qualifiersUnsupportedInPatterns(src, qualifiedCtx.getText());
            }
        }
        return result;
    }

    static List<String> breakIntoFragments(String idPattern) {
        ArrayList<String> fragments = new ArrayList<String>();
        char backtick = '`';
        boolean inQuotes = false;
        boolean keepGoing = true;
        int from = 0;
        int offset = -1;
        do {
            offset = idPattern.indexOf(backtick, offset);
            String fragment = null;
            if (offset < 0) {
                keepGoing = false;
                fragment = idPattern.substring(from);
            } else {
                if (!inQuotes) {
                    inQuotes = true;
                    if (offset != 0) {
                        fragment = idPattern.substring(from, offset);
                        from = offset;
                    }
                } else {
                    int ahead = offset + 1;
                    if (ahead < idPattern.length() && idPattern.charAt(ahead) == backtick) {
                        offset = ahead;
                    } else {
                        inQuotes = false;
                        fragment = idPattern.substring(from, ++offset);
                        from = offset;
                    }
                }
                ++offset;
            }
            if (fragment == null) continue;
            fragments.add(fragment);
        } while (keepGoing && offset <= idPattern.length());
        return fragments;
    }

    @Override
    public Object visitQualifiedIntegerLiteral(EsqlBaseParser.QualifiedIntegerLiteralContext ctx) {
        Source source = ParserUtils.source(ctx);
        Literal intLit = ParserUtils.typedParsing(this, (ParseTree)ctx.integerValue(), Literal.class);
        Number value = (Number)intLit.value();
        if (intLit.dataType() == DataType.UNSIGNED_LONG) {
            value = NumericUtils.unsignedLongAsNumber((long)value.longValue());
        }
        String qualifier = ctx.UNQUOTED_IDENTIFIER().getText().toLowerCase(Locale.ROOT);
        try {
            TemporalAmount quantity = EsqlDataTypeConverter.parseTemporalAmount(value, qualifier, source);
            return new Literal(source, (Object)quantity, quantity instanceof Duration ? DataType.TIME_DURATION : DataType.DATE_PERIOD);
        }
        catch (ArithmeticException | InvalidArgumentException e) {
            throw new ParsingException(source, "Number [{}] outside of [{}] range", ctx.integerValue().getText(), qualifier);
        }
    }

    @Override
    public Expression visitArithmeticUnary(EsqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression expr = this.expression((ParseTree)ctx.operatorExpression());
        Source source = ParserUtils.source(ctx);
        int type = ctx.operator.getType();
        return type == 88 ? new Neg(source, expr) : expr;
    }

    @Override
    public Expression visitArithmeticBinary(EsqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Source source = ParserUtils.source(ctx);
        int type = ctx.operator.getType();
        return switch (type) {
            case 89 -> new Mul(source, left, right);
            case 90 -> new Div(source, left, right);
            case 91 -> new Mod(source, left, right);
            case 87 -> new Add(source, left, right);
            case 88 -> new Sub(source, left, right);
            default -> throw new ParsingException(source, "Unknown arithmetic operator {}", source.text());
        };
    }

    @Override
    public Expression visitComparison(EsqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        return this.buildComparison(ParserUtils.source(ctx), left, right, op);
    }

    private Expression buildComparison(Source source, Expression left, Expression right, TerminalNode op) {
        ZoneId zoneId = DateUtils.UTC;
        return switch (op.getSymbol().getType()) {
            case 80 -> new Equals(source, left, right, zoneId);
            case 81 -> new InsensitiveEquals(source, left, right);
            case 82 -> new Not(source, (Expression)new Equals(source, left, right, zoneId));
            case 83 -> new LessThan(source, left, right, zoneId);
            case 84 -> new LessThanOrEqual(source, left, right, zoneId);
            case 85 -> new GreaterThan(source, left, right, zoneId);
            case 86 -> new GreaterThanOrEqual(source, left, right, zoneId);
            default -> throw new ParsingException(source, "Unknown comparison operator {}", op.getText());
        };
    }

    @Override
    public Not visitLogicalNot(EsqlBaseParser.LogicalNotContext ctx) {
        return new Not(ParserUtils.source(ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Expression visitParenthesizedExpression(EsqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.booleanExpression());
    }

    @Override
    public Expression visitOperatorExpressionDefault(EsqlBaseParser.OperatorExpressionDefaultContext ctx) {
        return this.expression((ParseTree)ctx.primaryExpression());
    }

    @Override
    public UnresolvedAttribute visitDereference(EsqlBaseParser.DereferenceContext ctx) {
        return this.visitQualifiedName(ctx.qualifiedName());
    }

    @Override
    public Expression visitFunctionExpression(EsqlBaseParser.FunctionExpressionContext ctx) {
        String name = this.visitFunctionName(ctx.functionName());
        List<Object> args = new ArrayList<Expression>(this.expressions(ctx.booleanExpression()));
        if (ctx.mapExpression() != null) {
            MapExpression mapArg = this.visitMapExpression(ctx.mapExpression());
            args.add((Expression)mapArg);
        }
        if ("is_null".equals(EsqlFunctionRegistry.normalizeName(name))) {
            throw new ParsingException(ParserUtils.source(ctx), "is_null function is not supported anymore, please use 'is null'/'is not null' predicates instead", new Object[0]);
        }
        if ("count".equals(EsqlFunctionRegistry.normalizeName(name)) && (args.isEmpty() || ctx.ASTERISK() != null)) {
            args = Collections.singletonList(Literal.keyword((Source)ParserUtils.source(ctx), (String)"*"));
        }
        return new UnresolvedFunction(ParserUtils.source(ctx), name, FunctionResolutionStrategy.DEFAULT, args);
    }

    @Override
    public String visitFunctionName(EsqlBaseParser.FunctionNameContext ctx) {
        String name = this.functionName(ctx);
        this.context.telemetry().function(name);
        return name;
    }

    private String functionName(EsqlBaseParser.FunctionNameContext ctx) {
        TerminalNode first = ctx.FIRST();
        if (first != null) {
            return first.getText();
        }
        TerminalNode last = ctx.LAST();
        if (last != null) {
            return last.getText();
        }
        return this.visitIdentifierOrParameter(ctx.identifierOrParameter());
    }

    @Override
    public MapExpression visitMapExpression(EsqlBaseParser.MapExpressionContext ctx) {
        ArrayList<Object> namedArgs = new ArrayList<Object>(ctx.entryExpression().size());
        ArrayList<String> names = new ArrayList<String>(ctx.entryExpression().size());
        List<EsqlBaseParser.EntryExpressionContext> kvCtx = ctx.entryExpression();
        for (EsqlBaseParser.EntryExpressionContext entry : kvCtx) {
            EsqlBaseParser.StringContext stringCtx = entry.string();
            String key = ExpressionBuilder.unquote(stringCtx.QUOTED_STRING().getText());
            if (key.isBlank()) {
                throw new ParsingException(ParserUtils.source(ctx), "Invalid named parameter [{}], empty key is not supported", entry.getText());
            }
            if (names.contains(key)) {
                throw new ParsingException(ParserUtils.source(ctx), "Duplicated named parameters with the same name [{}] is not supported", key);
            }
            Expression value = this.expression((ParseTree)(entry.value.constant() != null ? entry.value.constant() : entry.value.mapExpression()));
            String entryText = entry.getText();
            if (value instanceof Literal) {
                Literal l = (Literal)value;
                if (l.dataType() == DataType.NULL) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid named parameter [{}], NULL is not supported", entryText);
                }
                namedArgs.add(Literal.keyword((Source)ParserUtils.source(stringCtx), (String)key));
                namedArgs.add(l);
                names.add(key);
                continue;
            }
            if (value instanceof MapExpression) {
                namedArgs.add(Literal.keyword((Source)ParserUtils.source(stringCtx), (String)key));
                namedArgs.add(value);
                continue;
            }
            throw new ParsingException(ParserUtils.source(ctx), "Invalid named parameter [{}], only constant value is supported", entryText);
        }
        return new MapExpression(ParserUtils.source(ctx), namedArgs);
    }

    @Override
    public MapExpression visitCommandNamedParameters(EsqlBaseParser.CommandNamedParametersContext ctx) {
        return ctx == null || ctx.mapExpression() == null ? null : this.visitMapExpression(ctx.mapExpression());
    }

    @Override
    public String visitIdentifierOrParameter(EsqlBaseParser.IdentifierOrParameterContext ctx) {
        if (ctx.identifier() != null) {
            return this.visitIdentifier(ctx.identifier());
        }
        if (ctx.parameter() != null) {
            return this.unresolvedAttributeNameInParam(ctx.parameter(), this.expression((ParseTree)ctx.parameter()));
        }
        return this.unresolvedAttributeNameInParam(ctx.doubleParameter(), this.expression((ParseTree)ctx.doubleParameter()));
    }

    @Override
    public Expression visitInlineCast(EsqlBaseParser.InlineCastContext ctx) {
        return this.castToType(ParserUtils.source(ctx), (ParseTree)ctx.primaryExpression(), ctx.dataType());
    }

    private Expression castToType(Source source, ParseTree parseTree, EsqlBaseParser.DataTypeContext dataTypeCtx) {
        DataType dataType = ParserUtils.typedParsing(this, (ParseTree)dataTypeCtx, DataType.class);
        BiFunction<Source, Expression, AbstractConvertFunction> converterToFactory = EsqlDataTypeConverter.converterFunctionFactory(dataType);
        if (converterToFactory == null) {
            throw new ParsingException(source, "Unsupported conversion to type [{}]", dataType);
        }
        Expression expr = this.expression(parseTree);
        AbstractConvertFunction convertFunction = converterToFactory.apply(source, expr);
        this.context.telemetry().function(convertFunction.getClass());
        return convertFunction;
    }

    @Override
    public DataType visitToDataType(EsqlBaseParser.ToDataTypeContext ctx) {
        String typeName = this.visitIdentifier(ctx.identifier());
        DataType dataType = DataType.fromNameOrAlias((String)typeName);
        if (dataType == DataType.UNSUPPORTED) {
            throw new ParsingException(ParserUtils.source(ctx), "Unknown data type named [{}]", typeName);
        }
        return dataType;
    }

    @Override
    public Expression visitLogicalBinary(EsqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Source source = ParserUtils.source(ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        return type == 55 ? new And(source, left, right) : new Or(source, left, right);
    }

    @Override
    public Expression visitLogicalIn(EsqlBaseParser.LogicalInContext ctx) {
        List<Expression> expressions = ctx.valueExpression().stream().map(this::expression).toList();
        Source source = ParserUtils.source(ctx);
        EvaluatorMapper e = expressions.size() == 2 ? new Equals(source, expressions.get(0), expressions.get(1)) : new In(source, expressions.get(0), expressions.subList(1, expressions.size()));
        return ctx.NOT() == null ? e : new Not(source, (Expression)e);
    }

    @Override
    public Object visitIsNull(EsqlBaseParser.IsNullContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.valueExpression());
        Source source = ParserUtils.source(ctx.valueExpression(), (ParserRuleContext)ctx);
        return ctx.NOT() != null ? new IsNotNull(source, exp) : new IsNull(source, exp);
    }

    @Override
    public Expression visitRlikeExpression(EsqlBaseParser.RlikeExpressionContext ctx) {
        Source source = ParserUtils.source(ctx);
        String opname = ctx.RLIKE().getText();
        Expression left = this.expression((ParseTree)ctx.valueExpression());
        EsqlBaseParser.StringOrParameterContext right = ctx.stringOrParameter();
        String patternString = this.stringFromStringOrParameter(source, opname, right, INVALID_REGEX);
        try {
            RLike rLike = new RLike(source, left, new RLikePattern(patternString));
            return ctx.NOT() == null ? rLike : new Not(source, (Expression)rLike);
        }
        catch (InvalidArgumentException e) {
            throw new ParsingException(source, "Invalid pattern for RLIKE [{}]: [{}]", patternString, e.getMessage());
        }
    }

    @Override
    public Expression visitLikeExpression(EsqlBaseParser.LikeExpressionContext ctx) {
        Source source = ParserUtils.source(ctx);
        String opname = ctx.LIKE().getText();
        Expression left = this.expression((ParseTree)ctx.valueExpression());
        EsqlBaseParser.StringOrParameterContext right = ctx.stringOrParameter();
        String patternString = this.stringFromStringOrParameter(source, opname, right, INVALID_WILDCARD);
        try {
            WildcardPattern pattern = new WildcardPattern(patternString);
            WildcardLike result = new WildcardLike(source, left, pattern);
            return ctx.NOT() == null ? result : new Not(source, (Expression)result);
        }
        catch (InvalidArgumentException e) {
            throw new ParsingException(source, "Invalid pattern for LIKE [{}]: [{}]", patternString, e.getMessage());
        }
    }

    @Override
    public Expression visitLikeListExpression(EsqlBaseParser.LikeListExpressionContext ctx) {
        Source source = ParserUtils.source(ctx);
        String opname = ctx.LIKE().getText();
        Expression left = this.expression((ParseTree)ctx.valueExpression());
        List<EsqlBaseParser.StringOrParameterContext> right = ctx.stringOrParameter();
        List<WildcardPattern> wildcardPatterns = right.stream().map(x -> new WildcardPattern(this.stringFromStringOrParameter(source, opname, (EsqlBaseParser.StringOrParameterContext)((Object)x), INVALID_WILDCARD))).toList();
        RegexMatch e = wildcardPatterns.size() == 1 ? new WildcardLike(source, left, wildcardPatterns.getFirst()) : new WildcardLikeList(source, left, new WildcardPatternList(wildcardPatterns));
        return ctx.NOT() == null ? e : new Not(source, (Expression)e);
    }

    @Override
    public Expression visitRlikeListExpression(EsqlBaseParser.RlikeListExpressionContext ctx) {
        Source source = ParserUtils.source(ctx);
        String opname = ctx.RLIKE().getText();
        Expression left = this.expression((ParseTree)ctx.valueExpression());
        List<EsqlBaseParser.StringOrParameterContext> right = ctx.stringOrParameter();
        List<RLikePattern> rLikePatterns = right.stream().map(x -> new RLikePattern(this.stringFromStringOrParameter(source, opname, (EsqlBaseParser.StringOrParameterContext)((Object)x), INVALID_REGEX))).toList();
        RegexMatch e = rLikePatterns.size() == 1 ? new RLike(source, left, rLikePatterns.getFirst()) : new RLikeList(source, left, new RLikePatternList(rLikePatterns));
        return ctx.NOT() == null ? e : new Not(source, (Expression)e);
    }

    String stringFromStringOrParameter(Source expressionSource, String opname, EsqlBaseParser.StringOrParameterContext ctx, String invalid) {
        EsqlBaseParser.StringContext sctx = ctx.string();
        if (sctx != null) {
            Literal lit = this.visitString(sctx);
            return BytesRefs.toString((Object)lit.fold(FoldContext.small()));
        }
        EsqlBaseParser.ParameterContext pctx = ctx.parameter();
        if (pctx != null) {
            Source parameterSource = ParserUtils.source(ctx);
            LikeQueryParam lqp = new LikeQueryParam(expressionSource, parameterSource, opname, pctx, invalid);
            if (lqp.isInvalidList()) {
                return invalid;
            }
            if (lqp.param != null) {
                return lqp.patternString();
            }
        }
        this.context.params().addParsingError(new ParsingException(expressionSource, "Invalid pattern for {} [{}]: expected string literal or parameter", opname, expressionSource.text()));
        return invalid;
    }

    @Override
    public Order visitOrderExpression(EsqlBaseParser.OrderExpressionContext ctx) {
        return new Order(ParserUtils.source(ctx), this.expression((ParseTree)ctx.booleanExpression()), ctx.DESC() != null ? Order.OrderDirection.DESC : Order.OrderDirection.ASC, ctx.NULLS() != null && ctx.LAST() != null || ctx.NULLS() == null && ctx.DESC() == null ? Order.NullsPosition.LAST : Order.NullsPosition.FIRST);
    }

    @Override
    public Alias visitRenameClause(EsqlBaseParser.RenameClauseContext ctx) {
        Source src = ParserUtils.source(ctx);
        NamedExpression newName = this.visitQualifiedNamePattern(ctx.newName);
        NamedExpression oldName = this.visitQualifiedNamePattern(ctx.oldName);
        if (newName instanceof UnresolvedNamePattern || oldName instanceof UnresolvedNamePattern || newName instanceof UnresolvedStar || oldName instanceof UnresolvedStar) {
            throw new ParsingException(src, "Using wildcards [*] in RENAME is not allowed [{}]", src.text());
        }
        assert (newName instanceof UnresolvedAttribute && oldName instanceof UnresolvedAttribute);
        UnresolvedAttribute ua = (UnresolvedAttribute)newName;
        if (ua.qualifier() != null) {
            throw ExpressionBuilder.qualifiersUnsupportedInFieldDefinitions(src, ctx.newName.getText());
        }
        return new Alias(src, newName.name(), (Expression)oldName);
    }

    @Override
    public NamedExpression visitEnrichWithClause(EsqlBaseParser.EnrichWithClauseContext ctx) {
        Source src = ParserUtils.source(ctx);
        NamedExpression enrichField = this.enrichFieldName(ctx.enrichField);
        NamedExpression newName = this.enrichFieldName(ctx.newName);
        return newName == null ? enrichField : new Alias(src, newName.name(), (Expression)enrichField);
    }

    private NamedExpression enrichFieldName(EsqlBaseParser.QualifiedNamePatternContext ctx) {
        if (ctx != null && ctx.qualifier != null) {
            throw new ParsingException(ParserUtils.source(ctx), "Using qualifiers in ENRICH WITH projections is not allowed, found [{}]", ctx.getText());
        }
        return this.visitQualifiedNamePattern(ctx, ne -> {
            if (ne instanceof UnresolvedNamePattern || ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Using wildcards [*] in ENRICH WITH projections is not allowed, found [{}]", src.text());
            }
        });
    }

    @Override
    public Alias visitField(EsqlBaseParser.FieldContext ctx) {
        return this.visitField(ctx, ParserUtils.source(ctx));
    }

    private Alias visitField(EsqlBaseParser.FieldContext ctx, Source source) {
        UnresolvedAttribute id = this.visitQualifiedName(ctx.qualifiedName());
        if (id != null && id.qualifier() != null) {
            throw ExpressionBuilder.qualifiersUnsupportedInFieldDefinitions(source, ctx.qualifiedName().getText());
        }
        Expression value = this.expression((ParseTree)ctx.booleanExpression());
        String name = id == null ? source.text() : id.name();
        return new Alias(source, name, value);
    }

    @Override
    public List<Alias> visitFields(EsqlBaseParser.FieldsContext ctx) {
        return ctx != null ? ParserUtils.visitList(this, ctx.field(), Alias.class) : new ArrayList<Alias>();
    }

    @Override
    public Alias visitRerankField(EsqlBaseParser.RerankFieldContext ctx) {
        return this.visitRerankField(ctx, ParserUtils.source(ctx));
    }

    private Alias visitRerankField(EsqlBaseParser.RerankFieldContext ctx, Source source) {
        UnresolvedAttribute id = this.visitQualifiedName(ctx.qualifiedName());
        assert (id != null);
        EsqlBaseParser.BooleanExpressionContext boolExprCtx = ctx.booleanExpression();
        UnresolvedAttribute value = boolExprCtx == null ? id : this.expression((ParseTree)boolExprCtx);
        return new Alias(source, id.qualifier() != null ? id.qualifiedName() : id.name(), (Expression)value);
    }

    @Override
    public List<Alias> visitRerankFields(EsqlBaseParser.RerankFieldsContext ctx) {
        return ctx != null ? ParserUtils.visitList(this, ctx.rerankField(), Alias.class) : new ArrayList<Alias>();
    }

    @Override
    public NamedExpression visitAggField(EsqlBaseParser.AggFieldContext ctx) {
        Source source = ParserUtils.source(ctx);
        Alias field = this.visitField(ctx.field(), source);
        EsqlBaseParser.BooleanExpressionContext filterExpression = ctx.booleanExpression();
        if (filterExpression != null) {
            Expression condition = this.expression((ParseTree)filterExpression);
            Expression child = field.child();
            if (field.child().anyMatch(Function.class::isInstance)) {
                field = field.replaceChild((Expression)new FilteredExpression(field.source(), child, condition));
            } else {
                throw new ParsingException(condition.source(), "WHERE clause allowed only for aggregate functions [{}]", field.sourceText());
            }
        }
        return field;
    }

    @Override
    public List<Alias> visitAggFields(EsqlBaseParser.AggFieldsContext ctx) {
        return ctx != null ? ParserUtils.visitList(this, ctx.aggField(), Alias.class) : new ArrayList<Alias>();
    }

    public List<NamedExpression> visitGrouping(EsqlBaseParser.FieldsContext ctx) {
        ArrayList<Object> list;
        if (ctx != null) {
            List<EsqlBaseParser.FieldContext> fields = ctx.field();
            list = new ArrayList(fields.size());
            for (EsqlBaseParser.FieldContext field : fields) {
                Attribute ne = null;
                UnresolvedAttribute id = this.visitQualifiedName(field.qualifiedName());
                Expression value = this.expression((ParseTree)field.booleanExpression());
                String name = null;
                if (id == null) {
                    if (value instanceof Attribute) {
                        Attribute a;
                        ne = a = (Attribute)value;
                    } else {
                        name = ParserUtils.source(field).text();
                    }
                } else {
                    if (id.qualifier() != null) {
                        throw ExpressionBuilder.qualifiersUnsupportedInFieldDefinitions(ParserUtils.source(field), field.qualifiedName().getText());
                    }
                    name = id.name();
                }
                if (ne == null) {
                    ne = new Alias(ParserUtils.source(field), name, value);
                }
                list.add((NamedExpression)ne);
            }
        } else {
            list = new ArrayList<NamedExpression>();
        }
        return list;
    }

    @Override
    public Expression visitInputParam(EsqlBaseParser.InputParamContext ctx) {
        QueryParam param = this.paramByToken(ctx.PARAM());
        return this.visitParam(ParserUtils.source(ctx), param);
    }

    @Override
    public Expression visitInputNamedOrPositionalParam(EsqlBaseParser.InputNamedOrPositionalParamContext ctx) {
        QueryParam param = this.paramByNameOrPosition(ctx.NAMED_OR_POSITIONAL_PARAM());
        if (param == null) {
            return Literal.NULL;
        }
        return this.visitParam(ParserUtils.source(ctx), param);
    }

    private Expression visitParam(Source parameterSource, QueryParam param) {
        DataType type = param.type();
        List<Object> value = param.value();
        ParserUtils.ParamClassification classification = param.classification();
        if (value != null && classification != ParserUtils.ParamClassification.VALUE) {
            if (classification == ParserUtils.ParamClassification.PATTERN) {
                return new UnresolvedNamePattern(parameterSource, null, value.toString(), value.toString());
            }
            return new UnresolvedAttribute(parameterSource, value.toString());
        }
        if (type == DataType.KEYWORD || type == DataType.TEXT) {
            if (value instanceof String) {
                value = BytesRefs.toBytesRef((Object)value);
            } else if (value instanceof List) {
                List list = value;
                value = list.stream().map(v -> v instanceof String ? BytesRefs.toBytesRef((Object)v) : v).toList();
            }
        }
        return new Literal(parameterSource, (Object)value, type);
    }

    QueryParam paramByToken(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        if (!this.context.params().contains(token)) {
            throw new ParsingException(ParserUtils.source(node), "Unexpected parameter", new Object[0]);
        }
        return this.context.params().get(token);
    }

    QueryParam paramByNameOrPosition(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        String nameOrPosition = ParserUtils.nameOrPosition(token);
        if (StringUtils.isInteger((String)nameOrPosition)) {
            int index = Integer.parseInt(nameOrPosition);
            if (this.context.params().get(index) == null) {
                Object message = "";
                int np = this.context.params().size();
                if (np > 0) {
                    message = ", did you mean " + (String)(np == 1 ? "position 1?" : "any position between 1 and " + np + "?");
                }
                this.context.params().addParsingError(new ParsingException(ParserUtils.source(node), "No parameter is defined for position " + index + (String)message, new Object[0]));
            }
            return this.context.params().get(index);
        }
        if (!this.context.params().contains(nameOrPosition)) {
            Object message = "";
            List potentialMatches = StringUtils.findSimilar((String)nameOrPosition, this.context.params().namedParams().keySet());
            if (potentialMatches.size() > 0) {
                message = ", did you mean " + (potentialMatches.size() == 1 ? "[" + (String)potentialMatches.get(0) + "]?" : "any of " + String.valueOf(potentialMatches) + "?");
            }
            this.context.params().addParsingError(new ParsingException(ParserUtils.source(node), "Unknown query parameter [" + nameOrPosition + "]" + (String)message, new Object[0]));
        }
        return this.context.params().get(nameOrPosition);
    }

    String unresolvedAttributeNameInParam(ParserRuleContext ctx, Expression param) {
        String invalidParam = "Query parameter [{}]{}, cannot be used as an identifier";
        Expression expression = param;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.class, UnresolvedNamePattern.class, UnresolvedAttribute.class}, (Object)expression2, n)) {
            case 0: {
                Literal lit = (Literal)expression2;
                throw new ParsingException(ParserUtils.source(ctx), invalidParam, ctx.getText(), lit.value() != null ? " with value [" + String.valueOf(lit) + "] declared as a constant" : " is null or undefined");
            }
            case 1: {
                UnresolvedNamePattern up = (UnresolvedNamePattern)expression2;
                throw new ParsingException(ParserUtils.source(ctx), invalidParam, ctx.getText(), "[" + up.name() + "] declared as a pattern");
            }
            case 2: {
                UnresolvedAttribute ua = (UnresolvedAttribute)expression2;
                if (ua.name() != null) {
                    return ua.name();
                }
                throw new ParsingException(ParserUtils.source(ctx), invalidParam, ctx.getText(), "[null]");
            }
        }
        throw new ParsingException(ParserUtils.source(ctx), invalidParam, ctx.getText(), "[null]");
    }

    @Override
    public Expression visitInputDoubleParams(EsqlBaseParser.InputDoubleParamsContext ctx) {
        QueryParam param = this.paramByToken(ctx.DOUBLE_PARAMS());
        return this.visitDoubleParam(ctx, param);
    }

    @Override
    public Expression visitInputNamedOrPositionalDoubleParams(EsqlBaseParser.InputNamedOrPositionalDoubleParamsContext ctx) {
        QueryParam param = this.paramByNameOrPosition(ctx.NAMED_OR_POSITIONAL_DOUBLE_PARAMS());
        if (param == null) {
            return new UnresolvedAttribute(ParserUtils.source(ctx), "null");
        }
        return this.visitDoubleParam(ctx, param);
    }

    private Expression visitDoubleParam(EsqlBaseParser.DoubleParameterContext ctx, QueryParam param) {
        if (param.classification() == ParserUtils.ParamClassification.PATTERN) {
            this.context.params.addParsingError(new ParsingException(ParserUtils.source(ctx), "Query parameter [{}]{}, cannot be used as an identifier", ctx.getText(), "[" + param.name() + "] declared as a pattern"));
        }
        return new UnresolvedAttribute(ParserUtils.source(ctx), param.value().toString());
    }

    @Override
    public Expression visitMatchBooleanExpression(EsqlBaseParser.MatchBooleanExpressionContext ctx) {
        Expression matchFieldExpression = ctx.fieldType != null ? this.castToType(ParserUtils.source(ctx), (ParseTree)ctx.fieldExp, ctx.fieldType) : this.expression((ParseTree)ctx.fieldExp);
        return new MatchOperator(ParserUtils.source(ctx), matchFieldExpression, this.expression((ParseTree)ctx.matchQuery));
    }

    public record ParsingContext(QueryParams params, PlanTelemetry telemetry) {
    }

    private final class LikeQueryParam {
        Source expressionSource;
        Source parameterSource;
        String opname;
        String invalid;
        QueryParam param;

        LikeQueryParam(Source expressionSource, Source parameterSource, String opname, EsqlBaseParser.ParameterContext pctx, String invalid) {
            this.expressionSource = expressionSource;
            this.parameterSource = parameterSource;
            this.opname = opname;
            this.invalid = invalid;
            if (pctx instanceof EsqlBaseParser.InputParamContext) {
                EsqlBaseParser.InputParamContext ipctx = (EsqlBaseParser.InputParamContext)pctx;
                this.param = ExpressionBuilder.this.paramByToken(ipctx.PARAM());
            } else if (pctx instanceof EsqlBaseParser.InputNamedOrPositionalParamContext) {
                EsqlBaseParser.InputNamedOrPositionalParamContext inopctx = (EsqlBaseParser.InputNamedOrPositionalParamContext)pctx;
                this.param = ExpressionBuilder.this.paramByNameOrPosition(inopctx.NAMED_OR_POSITIONAL_PARAM());
            } else {
                throw new ParsingException(expressionSource, "Unsupported parameter context", new Object[0]);
            }
        }

        boolean isInvalidList() {
            Object object;
            if (this.param != null && (object = this.param.value()) instanceof List) {
                List list = (List)object;
                ExpressionBuilder.this.context.params().addParsingError(new ParsingException(this.expressionSource, "Invalid pattern parameter type for {} [{}]: expected string, found list", this.opname, this.parameterSource.text()));
                return true;
            }
            return false;
        }

        String patternString() {
            Expression exp = ExpressionBuilder.this.visitParam(this.parameterSource, this.param);
            if (exp != null && exp instanceof Literal) {
                Literal lit = (Literal)exp;
                DataType type = lit.dataType();
                if (type == DataType.KEYWORD) {
                    return BytesRefs.toString((Object)lit.fold(FoldContext.small()));
                }
                ExpressionBuilder.this.context.params().addParsingError(new ParsingException(this.expressionSource, "Invalid pattern parameter type for {} [{}]: expected string, found {}", this.opname, this.parameterSource.text(), type.typeName()));
            }
            return this.invalid;
        }
    }
}

