/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;

public class PushCountQueryAndTagsToSource
extends PhysicalOptimizerRules.OptimizerRule<AggregateExec> {
    private static final Literal ZERO = new Literal(Source.EMPTY, (Object)0L, DataType.LONG);

    @Override
    protected PhysicalPlan rule(AggregateExec aggregateExec) {
        EsQueryExec queryExec;
        EvalExec evalExec;
        Count count;
        Alias alias;
        Object object;
        if (aggregateExec.aggregates().size() == 2 && (object = aggregateExec.aggregates().getFirst()) instanceof Alias && (object = (alias = (Alias)object).child()) instanceof Count && !(count = (Count)object).hasFilter() && count.field() instanceof Literal && (object = aggregateExec.child()) instanceof EvalExec && (object = (evalExec = (EvalExec)object).child()) instanceof EsQueryExec && (queryExec = (EsQueryExec)object).queryBuilderAndTags().size() > 1 && queryExec.queryBuilderAndTags().stream().allMatch(PushCountQueryAndTagsToSource::isSingleFilterQuery)) {
            EsStatsQueryExec statsQueryExec = new EsStatsQueryExec(queryExec.source(), queryExec.indexPattern(), null, queryExec.limit(), aggregateExec.output(), new EsStatsQueryExec.ByStat(queryExec.queryBuilderAndTags()));
            Attribute countAttr = statsQueryExec.output().get(1);
            return new FilterExec(Source.EMPTY, statsQueryExec, (Expression)new GreaterThan(Source.EMPTY, (Expression)countAttr, (Expression)ZERO));
        }
        return aggregateExec;
    }

    private static boolean isSingleFilterQuery(EsQueryExec.QueryBuilderAndTags queryBuilderAndTags) {
        QueryBuilder queryBuilder = queryBuilderAndTags.query();
        Objects.requireNonNull(queryBuilder);
        QueryBuilder queryBuilder2 = queryBuilder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleValueQuery.Builder.class, BoolQueryBuilder.class}, (Object)queryBuilder2, n)) {
            case 0 -> {
                SingleValueQuery.Builder unused = (SingleValueQuery.Builder)queryBuilder2;
                yield true;
            }
            case 1 -> {
                BoolQueryBuilder bq = (BoolQueryBuilder)queryBuilder2;
                if (bq.filter().size() + bq.must().size() + bq.should().size() + bq.mustNot().size() <= 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

