/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvDedupe
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvDedupe", MvDedupe::new);

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "version"}, description="Remove duplicate values from a multivalued field.", note="`MV_DEDUPE` may, but won\u2019t always, sort the values in the column.", examples={@Example(file="string", tag="mv_dedupe")})
    public MvDedupe(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression field) {
        super(source, field);
    }

    private MvDedupe(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvDedupe.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return MultivalueDedupe.evaluator((ElementType)PlannerUtils.toElementType(this.dataType()), (EvalOperator.ExpressionEvaluator.Factory)fieldEval);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvDedupe(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvDedupe::new, (Object)this.field());
    }
}

