/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.HistogramMerge;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class HistogramMergeOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "HistogramMergeOverTime", HistogramMergeOverTime::new);

    @FunctionInfo(returnType={"exponential_histogram"}, type=FunctionType.TIME_SERIES_AGGREGATE)
    public HistogramMergeOverTime(Source source, @Param(name="histogram", type={"exponential_histogram"}) Expression field, @Param(name="window", type={"time_duration"}, optional=true) Expression window) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW));
    }

    public HistogramMergeOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private HistogramMergeOverTime(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public String getWriteableName() {
        return HistogramMergeOverTime.ENTRY.name;
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    protected NodeInfo<HistogramMergeOverTime> info() {
        return NodeInfo.create((Node)this, HistogramMergeOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public HistogramMergeOverTime replaceChildren(List<Expression> newChildren) {
        return new HistogramMergeOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public HistogramMergeOverTime withFilter(Expression filter) {
        return new HistogramMergeOverTime(this.source(), this.field(), filter, this.window());
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new HistogramMerge(this.source(), this.field(), this.filter(), this.window());
    }
}

