/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;

public class LoggingChunkedRestResponseBodyPart
implements ChunkedRestResponseBodyPart {
    private final ChunkedRestResponseBodyPart inner;
    private final OutputStream loggerStream;

    public LoggingChunkedRestResponseBodyPart(ChunkedRestResponseBodyPart inner, OutputStream loggerStream) {
        this.inner = inner;
        this.loggerStream = loggerStream;
    }

    @Override
    public boolean isPartComplete() {
        return this.inner.isPartComplete();
    }

    @Override
    public boolean isLastPart() {
        return this.inner.isLastPart();
    }

    @Override
    public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
        this.inner.getNextPart(listener.map(continuation -> new LoggingChunkedRestResponseBodyPart((ChunkedRestResponseBodyPart)continuation, this.loggerStream)));
    }

    @Override
    public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
        ReleasableBytesReference chunk;
        block2: {
            chunk = this.inner.encodeChunk(sizeHint, recycler);
            try {
                chunk.writeTo(this.loggerStream);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return chunk;
    }

    @Override
    public String getResponseContentTypeString() {
        return this.inner.getResponseContentTypeString();
    }
}

