/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.elasticsearch.index.codec.vectors.BFloat16;

abstract class OffHeapBFloat16VectorValues
extends FloatVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final byte[] bfloatBytes;
    protected final float[] value;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer flatVectorsScorer;

    OffHeapBFloat16VectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.similarityFunction = similarityFunction;
        this.flatVectorsScorer = flatVectorsScorer;
        this.bfloatBytes = new byte[dimension * 2];
        this.value = new float[dimension];
        assert (!(this instanceof HasIndexSlice)) : "BFloat16 should not implement HasIndexSlice until a bfloat16 scorer is created, else Lucene99MemorySegmentFlatVectorsScorer will try to access 4-byte floats here";
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.bfloatBytes, 0, this.bfloatBytes.length);
        BFloat16.bFloat16ToFloat(this.bfloatBytes, this.value);
        this.lastOrd = targetOrd;
        return this.value;
    }

    static OffHeapBFloat16VectorValues load(VectorSimilarityFunction vectorSimilarityFunction, FlatVectorsScorer flatVectorsScorer, OrdToDocDISIReaderConfiguration configuration, VectorEncoding vectorEncoding, int dimension, int size, long vectorDataOffset, long vectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty() || vectorEncoding != VectorEncoding.FLOAT32) {
            return new EmptyOffHeapVectorValues(dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", vectorDataOffset, vectorDataLength);
        int byteSize = dimension * 2;
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, bytesSlice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
        }
        return new SparseOffHeapVectorValues(configuration, vectorData, bytesSlice, dimension, size, byteSize, flatVectorsScorer, vectorSimilarityFunction);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapBFloat16VectorValues {
        EmptyOffHeapVectorValues(int dimension, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, 0, null, 0, flatVectorsScorer, similarityFunction);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        public EmptyOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            throw new UnsupportedOperationException();
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        public VectorScorer scorer(float[] query) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapBFloat16VectorValues {
        DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, size, slice, byteSize, flatVectorsScorer, similarityFunction);
        }

        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        public int ordToDoc(int ord) {
            return ord;
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public VectorScorer scorer(float[] query) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            return new VectorScorer(){

                public float score() throws IOException {
                    return randomVectorScorer.score(iterator.docID());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapBFloat16VectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, IndexInput dataIn, IndexInput slice, int dimension, int size, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) throws IOException {
            super(dimension, size, slice, byteSize, flatVectorsScorer, similarityFunction);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dataIn, this.slice.clone(), this.dimension, this.size, this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        public VectorScorer scorer(float[] query) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, query);
            return new VectorScorer(){

                public float score() throws IOException {
                    return randomVectorScorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

