/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.elasticsearch.index.codec.vectors.VectorScoringUtils;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class ES93FlatVectorFormat
extends KnnVectorsFormat {
    static final String NAME = "ES93FlatVectorFormat";
    private final FlatVectorsFormat format;

    public ES93FlatVectorFormat() {
        super(NAME);
        this.format = new ES93GenericFlatVectorsFormat();
    }

    public ES93FlatVectorFormat(DenseVectorFieldMapper.ElementType elementType) {
        super(NAME);
        assert (elementType != DenseVectorFieldMapper.ElementType.BIT) : "ES815BitFlatVectorFormat should be used for bits";
        this.format = new ES93GenericFlatVectorsFormat(elementType, false);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.format.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES93FlatVectorReader(this.format.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    static class ES93FlatVectorReader
    extends KnnVectorsReader {
        private final FlatVectorsReader reader;

        ES93FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.reader.getOffHeapByteSize(fieldInfo);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

