/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.index.mapper.SyntheticIdField;

public class TSDBSyntheticIdCodec
extends FilterCodec {
    private final RewriteFieldInfosFormat fieldInfosFormat;

    public TSDBSyntheticIdCodec(String name, Codec delegate) {
        super(name, delegate);
        this.fieldInfosFormat = new RewriteFieldInfosFormat(delegate.fieldInfosFormat());
    }

    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    private static class RewriteFieldInfosFormat
    extends FieldInfosFormat {
        private final FieldInfosFormat delegate;

        private RewriteFieldInfosFormat(FieldInfosFormat delegate) {
            this.delegate = delegate;
        }

        private void ensureSyntheticIdFields(FieldInfos fieldInfos) {
            FieldInfo fi = fieldInfos.fieldInfo("_tsid");
            if (fi == null) {
                String message = "Field [_tsid] does not exist";
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
            fi = fieldInfos.fieldInfo("@timestamp");
            if (fi == null) {
                String message = "Field [@timestamp] does not exist";
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
            fi = fieldInfos.fieldInfo("_ts_routing_hash");
            if (fi == null) {
                String message = "Field [_ts_routing_hash] does not exist";
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
            fi = fieldInfos.fieldInfo("_id");
            if (fi == null) {
                String message = "Field [_id] does not exist";
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
            if (fi.getIndexOptions() != IndexOptions.NONE) {
                assert (false);
                throw new IllegalArgumentException("Field [_id] has incorrect index options");
            }
            if (!SyntheticIdField.hasSyntheticIdAttributes(fi.attributes())) {
                throw new IllegalArgumentException("Field [_id] is not synthetic");
            }
        }

        public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos fieldInfos, IOContext context) throws IOException {
            FieldInfo[] infos = new FieldInfo[fieldInfos.size()];
            int i = 0;
            for (FieldInfo fi : fieldInfos) {
                if ("_id".equals(fi.getName())) {
                    HashMap attributes = new HashMap(fi.attributes());
                    assert (attributes.get(PerFieldPostingsFormat.PER_FIELD_FORMAT_KEY) == null || "TSDBSyntheticId".equals(attributes.get(PerFieldPostingsFormat.PER_FIELD_FORMAT_KEY)));
                    assert (attributes.get(PerFieldPostingsFormat.PER_FIELD_SUFFIX_KEY) == null || "0".equals(attributes.get(PerFieldPostingsFormat.PER_FIELD_SUFFIX_KEY)));
                    attributes.remove(PerFieldPostingsFormat.PER_FIELD_FORMAT_KEY);
                    attributes.remove(PerFieldPostingsFormat.PER_FIELD_SUFFIX_KEY);
                    fi = new FieldInfo(fi.getName(), fi.getFieldNumber(), fi.hasTermVectors(), true, fi.hasPayloads(), IndexOptions.NONE, fi.getDocValuesType(), fi.docValuesSkipIndexType(), fi.getDocValuesGen(), attributes, fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
                }
                infos[i++] = fi;
            }
            fieldInfos = new FieldInfos(infos);
            this.ensureSyntheticIdFields(fieldInfos);
            this.delegate.write(directory, segmentInfo, segmentSuffix, fieldInfos, context);
        }

        public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
            FieldInfos fieldInfos = this.delegate.read(directory, segmentInfo, segmentSuffix, iocontext);
            this.ensureSyntheticIdFields(fieldInfos);
            FieldInfo[] infos = new FieldInfo[fieldInfos.size()];
            int i = 0;
            for (FieldInfo fi : fieldInfos) {
                if ("_id".equals(fi.getName())) {
                    HashMap<String, String> attributes = new HashMap<String, String>(fi.attributes());
                    assert (!attributes.containsKey(PerFieldPostingsFormat.PER_FIELD_FORMAT_KEY));
                    assert (!attributes.containsKey(PerFieldPostingsFormat.PER_FIELD_SUFFIX_KEY));
                    attributes.put(PerFieldPostingsFormat.PER_FIELD_FORMAT_KEY, "TSDBSyntheticId");
                    attributes.put(PerFieldPostingsFormat.PER_FIELD_SUFFIX_KEY, "0");
                    fi = new FieldInfo(fi.getName(), fi.getFieldNumber(), fi.hasTermVectors(), true, fi.hasPayloads(), IndexOptions.DOCS, fi.getDocValuesType(), fi.docValuesSkipIndexType(), fi.getDocValuesGen(), attributes, fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
                }
                infos[i++] = fi;
            }
            return new FieldInfos(infos);
        }
    }
}

