/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.DerivIntAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SimpleLinearRegressionWithTimeseries;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class DerivIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("count", ElementType.LONG), new IntermediateStateDesc("sumVal", ElementType.DOUBLE), new IntermediateStateDesc("sumTs", ElementType.DOUBLE), new IntermediateStateDesc("sumTsVal", ElementType.DOUBLE), new IntermediateStateDesc("sumTsSq", ElementType.DOUBLE));
    private final DriverContext driverContext;
    private final SimpleLinearRegressionWithTimeseries state;
    private final List<Integer> channels;
    private final boolean dateNanos;

    public DerivIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, SimpleLinearRegressionWithTimeseries state, boolean dateNanos) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.dateNanos = dateNanos;
    }

    public static DerivIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels, boolean dateNanos) {
        return new DerivIntAggregatorFunction(driverContext, channels, DerivIntAggregator.initSingle(driverContext, dateNanos), dateNanos);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        IntVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        this.addRawVector(valueVector, timestampVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        IntVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        this.addRawVector(valueVector, timestampVector);
    }

    private void addRawVector(IntVector valueVector, LongVector timestampVector) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            int valueValue = valueVector.getInt(valuesPosition);
            long timestampValue = timestampVector.getLong(valuesPosition);
            DerivIntAggregator.combine(this.state, valueValue, timestampValue);
        }
    }

    private void addRawVector(IntVector valueVector, LongVector timestampVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            int valueValue = valueVector.getInt(valuesPosition);
            long timestampValue = timestampVector.getLong(valuesPosition);
            DerivIntAggregator.combine(this.state, valueValue, timestampValue);
        }
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                int valueValue = valueBlock.getInt(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    DerivIntAggregator.combine(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                int valueValue = valueBlock.getInt(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    DerivIntAggregator.combine(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + DerivIntAggregatorFunction.intermediateStateDesc().size());
        Object countUncast = page.getBlock(this.channels.get(0));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (count.getPositionCount() == 1);
        Object sumValUncast = page.getBlock(this.channels.get(1));
        if (sumValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector sumVal = ((DoubleBlock)sumValUncast).asVector();
        assert (sumVal.getPositionCount() == 1);
        Object sumTsUncast = page.getBlock(this.channels.get(2));
        if (sumTsUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector sumTs = ((DoubleBlock)sumTsUncast).asVector();
        assert (sumTs.getPositionCount() == 1);
        Object sumTsValUncast = page.getBlock(this.channels.get(3));
        if (sumTsValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector sumTsVal = ((DoubleBlock)sumTsValUncast).asVector();
        assert (sumTsVal.getPositionCount() == 1);
        Object sumTsSqUncast = page.getBlock(this.channels.get(4));
        if (sumTsSqUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector sumTsSq = ((DoubleBlock)sumTsSqUncast).asVector();
        assert (sumTsSq.getPositionCount() == 1);
        DerivIntAggregator.combineIntermediate(this.state, count.getLong(0), sumVal.getDouble(0), sumTs.getDouble(0), sumTsVal.getDouble(0), sumTsSq.getDouble(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = DerivIntAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

