/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;

final class ExponentialHistogramMetricFieldProducer
extends AbstractDownsampleFieldProducer<ExponentialHistogramValuesReader> {
    private ExponentialHistogramMerger merger = null;

    ExponentialHistogramMetricFieldProducer(String name) {
        super(name);
    }

    static AbstractDownsampleFieldProducer<?> createMetricProducerForExponentialHistogram(String name, DownsampleConfig.SamplingMethod samplingMethod) {
        return switch (samplingMethod) {
            default -> throw new MatchException(null, null);
            case DownsampleConfig.SamplingMethod.AGGREGATE -> new ExponentialHistogramMetricFieldProducer(name);
            case DownsampleConfig.SamplingMethod.LAST_VALUE -> new LastValueFieldProducer.ExponentialHistogramFieldProducer(name);
        };
    }

    @Override
    public void collect(ExponentialHistogramValuesReader docValues, IntArrayList docIdBuffer) throws IOException {
        for (int i = 0; i < docIdBuffer.size(); ++i) {
            int docId = docIdBuffer.get(i);
            if (!docValues.advanceExact(docId)) continue;
            this.isEmpty = false;
            if (this.merger == null) {
                this.merger = ExponentialHistogramMerger.create((ExponentialHistogramCircuitBreaker)ExponentialHistogramCircuitBreaker.noop());
            }
            ExponentialHistogram value = docValues.histogramValue();
            this.merger.add(value);
        }
    }

    @Override
    public void reset() {
        this.isEmpty = true;
        this.merger = null;
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (!this.isEmpty()) {
            builder.field(this.name());
            ExponentialHistogramXContent.serialize((XContentBuilder)builder, (ExponentialHistogram)this.merger.get());
            this.merger.close();
        }
    }
}

