/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.DownsampleFieldSerializer;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;
import org.elasticsearch.xpack.downsample.NumericMetricFieldProducer;

final class AggregateMetricFieldSerializer
implements DownsampleFieldSerializer {
    private final Collection<AbstractDownsampleFieldProducer<?>> producers;
    private final String name;

    AggregateMetricFieldSerializer(String name, Collection<AbstractDownsampleFieldProducer<?>> producers) {
        this.name = name;
        this.producers = producers;
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        builder.startObject(this.name);
        block11: for (AbstractDownsampleFieldProducer<?> fieldProducer : this.producers) {
            AbstractDownsampleFieldProducer<?> abstractDownsampleFieldProducer;
            assert (this.name.equals(fieldProducer.name())) : "producer has a different name";
            if (fieldProducer.isEmpty()) continue;
            Objects.requireNonNull(fieldProducer);
            int n = 0;
            block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumericMetricFieldProducer.AggregateGaugeMetricFieldProducer.class, NumericMetricFieldProducer.AggregateSubMetricFieldProducer.class, LastValueFieldProducer.AggregateSubMetricFieldProducer.class}, abstractDownsampleFieldProducer, n)) {
                case 0: {
                    NumericMetricFieldProducer.AggregateGaugeMetricFieldProducer producer = (NumericMetricFieldProducer.AggregateGaugeMetricFieldProducer)abstractDownsampleFieldProducer;
                    builder.field("max", producer.max);
                    builder.field("min", producer.min);
                    builder.field("sum", producer.sum.value());
                    builder.field("value_count", producer.count);
                    break;
                }
                case 1: {
                    NumericMetricFieldProducer.AggregateSubMetricFieldProducer producer = (NumericMetricFieldProducer.AggregateSubMetricFieldProducer)abstractDownsampleFieldProducer;
                    switch (producer.metric) {
                        case max: {
                            builder.field("max", producer.max);
                            break block0;
                        }
                        case min: {
                            builder.field("min", producer.min);
                            break block0;
                        }
                        case sum: {
                            builder.field("sum", producer.sum.value());
                            break block0;
                        }
                        case value_count: {
                            builder.field("value_count", producer.count);
                        }
                    }
                    break;
                }
                case 2: {
                    LastValueFieldProducer.AggregateSubMetricFieldProducer lastValueFieldProducer = (LastValueFieldProducer.AggregateSubMetricFieldProducer)abstractDownsampleFieldProducer;
                    Object lastValue = lastValueFieldProducer.lastValue();
                    if (lastValue == null) continue block11;
                    builder.field(lastValueFieldProducer.subMetric(), lastValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field producer class: " + fieldProducer.getClass().getSimpleName() + " for " + this.name + " field");
                }
            }
        }
        builder.endObject();
    }

    private boolean isEmpty() {
        for (AbstractDownsampleFieldProducer<?> p : this.producers) {
            if (p.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

