/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.docbuilder;

import com.google.protobuf.ByteString;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.BufferedMurmur3Hasher;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPoint;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPointGroupingContext;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.TargetIndex;
import org.elasticsearch.xpack.oteldata.otlp.docbuilder.MappingHints;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;

public class MetricDocumentBuilder {
    private final BufferedByteStringAccessor byteStringAccessor;
    private final BufferedMurmur3Hasher hasher = new BufferedMurmur3Hasher(0L);

    public MetricDocumentBuilder(BufferedByteStringAccessor byteStringAccessor) {
        this.byteStringAccessor = byteStringAccessor;
    }

    public BytesRef buildMetricDocument(XContentBuilder builder, DataPointGroupingContext.DataPointGroup dataPointGroup, Map<String, String> dynamicTemplates, Map<String, Map<String, String>> dynamicTemplateParams) throws IOException {
        List<DataPoint> dataPoints = dataPointGroup.dataPoints();
        builder.startObject();
        builder.field("@timestamp", TimeUnit.NANOSECONDS.toMillis(dataPointGroup.getTimestampUnixNano()));
        if (dataPointGroup.getStartTimestampUnixNano() != 0L) {
            builder.field("start_timestamp", TimeUnit.NANOSECONDS.toMillis(dataPointGroup.getStartTimestampUnixNano()));
        }
        this.buildResource(dataPointGroup.resource(), dataPointGroup.resourceSchemaUrl(), builder);
        this.buildDataStream(builder, dataPointGroup.targetIndex());
        this.buildScope(builder, dataPointGroup.scopeSchemaUrl(), dataPointGroup.scope());
        this.buildDataPointAttributes(builder, dataPointGroup.dataPointAttributes(), dataPointGroup.unit());
        String metricNamesHash = dataPointGroup.getMetricNamesHash(this.hasher);
        builder.field("_metric_names_hash", metricNamesHash);
        long docCount = 0L;
        builder.startObject("metrics");
        int dataPointsSize = dataPoints.size();
        for (int i = 0; i < dataPointsSize; ++i) {
            DataPoint dataPoint = dataPoints.get(i);
            builder.field(dataPoint.getMetricName());
            MappingHints mappingHints = MappingHints.fromAttributes(dataPoint.getAttributes());
            dataPoint.buildMetricValue(mappingHints, builder);
            String dynamicTemplate = dataPoint.getDynamicTemplate(mappingHints);
            if (dynamicTemplate != null) {
                String metricFieldPath = "metrics." + dataPoint.getMetricName();
                dynamicTemplates.put(metricFieldPath, dynamicTemplate);
                if (dataPointGroup.unit() != null && !dataPointGroup.unit().isEmpty()) {
                    dynamicTemplateParams.put(metricFieldPath, Map.of("unit", dataPointGroup.unit()));
                }
            }
            if (!mappingHints.docCount()) continue;
            docCount = dataPoint.getDocCount();
        }
        builder.endObject();
        if (docCount > 0L) {
            builder.field("_doc_count", docCount);
        }
        builder.endObject();
        TsidBuilder tsidBuilder = dataPointGroup.tsidBuilder();
        tsidBuilder.addStringDimension("_metric_names_hash", metricNamesHash);
        return tsidBuilder.buildTsid();
    }

    private void buildResource(Resource resource, ByteString schemaUrl, XContentBuilder builder) throws IOException {
        builder.startObject("resource");
        this.addFieldIfNotEmpty(builder, "schema_url", schemaUrl);
        if (resource.getDroppedAttributesCount() > 0) {
            builder.field("dropped_attributes_count", resource.getDroppedAttributesCount());
        }
        builder.startObject("attributes");
        this.buildAttributes(builder, resource.getAttributesList());
        builder.endObject();
        builder.endObject();
    }

    private void buildScope(XContentBuilder builder, ByteString schemaUrl, InstrumentationScope scope) throws IOException {
        builder.startObject("scope");
        this.addFieldIfNotEmpty(builder, "schema_url", schemaUrl);
        if (scope.getDroppedAttributesCount() > 0) {
            builder.field("dropped_attributes_count", scope.getDroppedAttributesCount());
        }
        this.addFieldIfNotEmpty(builder, "name", scope.getNameBytes());
        this.addFieldIfNotEmpty(builder, "version", scope.getVersionBytes());
        builder.startObject("attributes");
        this.buildAttributes(builder, scope.getAttributesList());
        builder.endObject();
        builder.endObject();
    }

    private void addFieldIfNotEmpty(XContentBuilder builder, String name, ByteString value) throws IOException {
        if (value != null && !value.isEmpty()) {
            builder.field(name);
            this.byteStringAccessor.utf8Value(builder, value);
        }
    }

    private void buildDataPointAttributes(XContentBuilder builder, List<KeyValue> attributes, String unit) throws IOException {
        builder.startObject("attributes");
        this.buildAttributes(builder, attributes);
        builder.endObject();
        if (Strings.hasLength((String)unit)) {
            builder.field("unit", unit);
        }
    }

    private void buildDataStream(XContentBuilder builder, TargetIndex targetIndex) throws IOException {
        if (!targetIndex.isDataStream()) {
            return;
        }
        builder.startObject("data_stream");
        builder.field("type", targetIndex.type());
        builder.field("dataset", targetIndex.dataset());
        builder.field("namespace", targetIndex.namespace());
        builder.endObject();
    }

    private void buildAttributes(XContentBuilder builder, List<KeyValue> attributes) throws IOException {
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            KeyValue attribute = attributes.get(i);
            String key = attribute.getKey();
            if (MetricDocumentBuilder.isIgnoredAttribute(key)) continue;
            builder.field(key);
            this.attributeValue(builder, attribute.getValue());
        }
    }

    public static boolean isIgnoredAttribute(String attributeKey) {
        return TargetIndex.isTargetIndexAttribute(attributeKey) || MappingHints.isMappingHintsAttribute(attributeKey);
    }

    private void attributeValue(XContentBuilder builder, AnyValue value) throws IOException {
        switch (value.getValueCase()) {
            case STRING_VALUE: {
                this.byteStringAccessor.utf8Value(builder, value.getStringValueBytes());
                break;
            }
            case BOOL_VALUE: {
                builder.value(value.getBoolValue());
                break;
            }
            case INT_VALUE: {
                builder.value(value.getIntValue());
                break;
            }
            case DOUBLE_VALUE: {
                builder.value(value.getDoubleValue());
                break;
            }
            case ARRAY_VALUE: {
                builder.startArray();
                List<AnyValue> valuesList = value.getArrayValue().getValuesList();
                int valuesListSize = valuesList.size();
                for (int i = 0; i < valuesListSize; ++i) {
                    AnyValue arrayValue = valuesList.get(i);
                    this.attributeValue(builder, arrayValue);
                }
                builder.endArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported attribute value type: " + String.valueOf((Object)value.getValueCase()));
            }
        }
    }
}

