/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp;

import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xpack.oteldata.otlp.OTLPMetricsTransportAction;

@ServerlessScope(value=Scope.PUBLIC)
public class OTLPMetricsRestAction
extends BaseRestHandler {
    public String getName() {
        return "otlp_metrics_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_otlp/v1/metrics"));
    }

    public boolean mediaTypesValid(RestRequest request) {
        return request.getXContentType() == null && request.getParsedContentType().mediaTypeWithoutParameters().equals("application/x-protobuf");
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.hasContent()) {
            OTLPMetricsTransportAction.MetricsRequest transportRequest = new OTLPMetricsTransportAction.MetricsRequest((BytesReference)request.content().retain());
            return channel -> client.execute(OTLPMetricsTransportAction.TYPE, (ActionRequest)transportRequest, ActionListener.releaseBefore((Releasable)request.content(), (ActionListener)new RestResponseListener<OTLPMetricsTransportAction.MetricsResponse>(this, channel){

                public RestResponse buildResponse(OTLPMetricsTransportAction.MetricsResponse r) {
                    return new RestResponse(r.getStatus(), "application/x-protobuf", r.getResponse());
                }
            }));
        }
        return channel -> channel.sendResponse(new RestResponse(RestStatus.OK, "application/x-protobuf", (BytesReference)new BytesArray(ExportMetricsServiceResponse.newBuilder().build().toByteArray())));
    }
}

