/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class BytesRefsFromCustomBinaryBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;

    public BytesRefsFromCustomBinaryBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return new BytesRefsFromCustomBinary(docValues);
    }

    static class BytesRefsFromCustomBinary
    extends AbstractBytesRefsFromBinary {
        private final ByteArrayStreamInput in = new ByteArrayStreamInput();
        private final BytesRef scratch = new BytesRef();

        BytesRefsFromCustomBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        @Override
        public void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            assert (bytes.length > 0);
            this.in.reset(bytes.bytes, bytes.offset, bytes.length);
            int count = this.in.readVInt();
            this.scratch.bytes = bytes.bytes;
            if (count == 1) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                builder.appendBytesRef(this.scratch);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                builder.appendBytesRef(this.scratch);
            }
            builder.endPositionEntry();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.BytesCustom";
        }
    }

    public static abstract class AbstractBytesRefsFromBinary
    extends BlockDocValuesReader {
        protected final BinaryDocValues docValues;

        public AbstractBytesRefsFromBinary(BinaryDocValues docValues) {
            this.docValues = docValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        public abstract void read(int var1, BlockLoader.BytesRefBuilder var2) throws IOException;
    }
}

