/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    protected final TextSearchInfo textSearchInfo;

    public TermBasedFieldType(String name, IndexType indexType, boolean isStored, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, indexType, isStored, meta);
        this.textSearchInfo = textSearchInfo;
    }

    @Override
    public TextSearchInfo getTextSearchInfo() {
        return this.textSearchInfo;
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        this.failIfNotIndexed();
        BytesRef valueForSearch = this.indexedValueForSearch(value);
        if (valueForSearch.length == 0) {
            return this.termQuery(value, context);
        }
        return AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), valueForSearch));
    }

    @Override
    public boolean mayExistInIndex(SearchExecutionContext context) {
        return context.fieldExistsInIndex(this.name());
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.failIfNotIndexed();
        return new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        this.failIfNotIndexed();
        List<BytesRef> bytesRefs = values.stream().map(this::indexedValueForSearch).toList();
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

