/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBooleanIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.BooleansBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.BooleanDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BooleanFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "boolean";
    public static final FieldMapper.TypeParser PARSER = BooleanFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, c.scriptCompiler(), c.getIndexSettings()));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Script script;
    private final FieldValues<Boolean> scriptValues;
    private final ScriptCompiler scriptCompiler;
    private final Explicit<Boolean> ignoreMalformed;
    private final IndexSettings indexSettings;
    private final boolean storeMalformedFields;
    private final String offsetsFieldName;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean storeMalformedFields, Builder builder, String offsetsFieldName) {
        super(simpleName, mappedFieldType, builderParams);
        this.nullValue = builder.nullValue.getValue();
        this.stored = builder.stored.getValue();
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
        this.indexSettings = builder.indexSettings;
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.storeMalformedFields = storeMalformedFields;
        this.offsetsFieldName = offsetsFieldName;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    public String getOffsetFieldName() {
        return this.offsetsFieldName;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = null;
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                value = this.nullValue;
            }
        } else {
            try {
                value = context.parser().booleanValue();
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue() && context.parser().currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    if (this.storeMalformedFields) {
                        context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                    }
                    return;
                }
                throw e;
            }
        }
        this.indexValue(context, value);
        if (this.offsetsFieldName != null && context.isImmediateParentAnArray() && context.canAddIgnoredField()) {
            if (value != null) {
                context.getOffSetContext().recordOffset(this.offsetsFieldName, value);
            } else {
                context.getOffSetContext().recordNull(this.offsetsFieldName);
            }
        }
    }

    private void indexValue(DocumentParserContext context, Boolean value) {
        if (value == null) {
            return;
        }
        if (this.fieldType().isDimension()) {
            context.getRoutingFields().addBoolean(this.fieldType().name(), value);
        }
        if (this.indexed) {
            context.doc().add((IndexableField)new StringField(this.fieldType().name(), value != false ? Values.TRUE : Values.FALSE, Field.Store.NO));
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            if (this.fieldType().indexType.hasDocValuesSkipper()) {
                context.doc().add((IndexableField)SortedNumericDocValuesField.indexedField((String)this.fieldType().name(), (long)(value != false ? 1L : 0L)));
            } else {
                context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
            }
        } else {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (Boolean)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.scriptCompiler, this.indexSettings).dimension(this.fieldType().isDimension()).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.fieldType().isDimension() && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    private SourceLoader.SyntheticFieldLoader docValuesSyntheticFieldLoader() {
        if (this.offsetsFieldName != null) {
            ArrayList<CompositeSyntheticFieldLoader.Layer> layers = new ArrayList<CompositeSyntheticFieldLoader.Layer>(2);
            layers.add(new SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer(this.fullPath(), this.offsetsFieldName, (b, value) -> b.value(value == 1L)));
            if (this.ignoreMalformed.value().booleanValue()) {
                layers.add(new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath()));
            }
            return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), layers);
        }
        return new SortedNumericDocValuesSyntheticFieldLoader(this, this.fullPath(), this.leafName(), this.ignoreMalformed.value()){

            @Override
            protected void writeValue(XContentBuilder b, long value) throws IOException {
                b.value(value == 1L);
            }
        };
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(this::docValuesSyntheticFieldLoader);
        }
        return super.syntheticSourceSupport();
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Boolean> nullValue = new FieldMapper.Parameter<Boolean>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValues.nodeBooleanValue(o)), m -> BooleanFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> BooleanFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> BooleanFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final IndexSettings indexSettings;
        private final FieldMapper.Parameter<Boolean> dimension;

        public Builder(String name, ScriptCompiler scriptCompiler, IndexSettings indexSettings) {
            super(name);
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.indexSettings = Objects.requireNonNull(indexSettings);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> BooleanFieldMapper.toType((FieldMapper)m).ignoreMalformed, FieldMapper.IGNORE_MALFORMED_SETTING.get(indexSettings.getSettings()));
            this.script.precludesParameters(this.ignoreMalformed, this.nullValue);
            this.dimension = TimeSeriesParams.dimensionParam(m -> BooleanFieldMapper.toType(m).fieldType().isDimension(), this.docValues::get);
            this.indexed = FieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.toType((FieldMapper)m).indexed, indexSettings, this.dimension);
            this.addScriptValidation(this.script, this.indexed, this.docValues);
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.docValues, this.indexed, this.nullValue, this.stored, this.script, this.onScriptErrorParam, this.ignoreMalformed, this.dimension};
        }

        private IndexType indexType() {
            if (this.indexed.get().booleanValue() && !this.indexSettings.getIndexVersionCreated().isLegacyIndexVersion()) {
                return IndexType.terms(true, this.docValues.getValue());
            }
            if (!this.docValues.get().booleanValue()) {
                return IndexType.NONE;
            }
            if (this.indexSettings.useDocValuesSkipper() && this.indexSettings.getIndexVersionCreated().onOrAfter(IndexVersions.STANDARD_INDEXES_USE_SKIPPERS)) {
                return IndexType.skippers();
            }
            return FieldMapper.Parameter.useTimeSeriesDocValuesSkippers(this.indexSettings, this.dimension.get()) ? IndexType.skippers() : IndexType.docValuesOnly();
        }

        @Override
        public BooleanFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension(true);
            }
            BooleanFieldType ft = new BooleanFieldType(context.buildFullName(this.leafName()), this.indexType(), this.stored.getValue(), this.nullValue.getValue(), this.scriptValues(), this.meta.getValue(), this.dimension.getValue(), context.isSourceSynthetic());
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.getValue();
            String offsetsFieldName = FieldArrayContext.getOffsetsFieldName(context, this.indexSettings.sourceKeepMode(), this.docValues.getValue(), this.stored.getValue(), this, this.indexSettings.getIndexVersionCreated(), IndexVersions.SYNTHETIC_SOURCE_STORE_ARRAYS_NATIVELY_BOOLEAN);
            return new BooleanFieldMapper(this.leafName(), ft, this.builderParams(this, context), context.isSourceSynthetic(), this, offsetsFieldName);
        }

        private FieldValues<Boolean> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            BooleanFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), BooleanFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;
        private final FieldValues<Boolean> scriptValues;
        private final boolean isDimension;
        private final boolean isSyntheticSource;

        public BooleanFieldType(String name, IndexType indexType, boolean isStored, Boolean nullValue, FieldValues<Boolean> scriptValues, Map<String, String> meta, boolean isDimension, boolean isSyntheticSource) {
            super(name, indexType, isStored, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isDimension = isDimension;
            this.isSyntheticSource = isSyntheticSource;
        }

        public BooleanFieldType(String name) {
            this(name, IndexType.terms(true, true));
        }

        public BooleanFieldType(String name, IndexType indexType) {
            this(name, indexType, true, false, null, Collections.emptyMap(), false, false);
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return this.indexType.hasTerms() || this.hasDocValues();
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet(), context.getIndexSettings());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths, IndexSettings indexSettings) {
            return new SourceValueFetcher(sourcePaths, this.nullValue, indexSettings.getIgnoredSourceFormat()){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return this.parseBoolean(textValue);
                }
            };
        }

        private boolean parseBoolean(String text) {
            return Booleans.parseBoolean((char[])text.toCharArray(), (int)0, (int)text.length(), (boolean)false);
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return switch (sValue) {
                case "true" -> Values.TRUE;
                case "false" -> Values.FALSE;
                default -> throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
            };
        }

        private long docValueForSearch(Object value) {
            BytesRef ref = this.indexedValueForSearch(value);
            if (Values.TRUE.equals((Object)ref)) {
                return 1L;
            }
            return 0L;
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return switch (value.toString()) {
                case "F" -> false;
                case "T" -> true;
                default -> throw new IllegalArgumentException("Expected [T] or [F] but got [" + String.valueOf(value) + "]");
            };
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BooleansBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return new FallbackSyntheticSourceBlockLoader(this, this.fallbackSyntheticSourceBlockLoaderReader(), this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat(blContext.indexSettings().getIndexVersionCreated())){

                    @Override
                    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                        return factory.booleans(expectedCount);
                    }
                };
            }
            SourceValueFetcher fetcher = this.sourceValueFetcher(blContext.sourcePaths(this.name()), blContext.indexSettings());
            BlockSourceReader.LeafIteratorLookup lookup = this.indexType.hasTerms() || this.isStored() ? BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.BooleansBlockLoader(fetcher, lookup);
        }

        private FallbackSyntheticSourceBlockLoader.Reader<?> fallbackSyntheticSourceBlockLoaderReader() {
            return new FallbackSyntheticSourceBlockLoader.SingleValueReader<Boolean>((Object)this.nullValue){

                @Override
                public void convertValue(Object value, List<Boolean> accumulator) {
                    try {
                        if (value instanceof Boolean) {
                            Boolean b = (Boolean)value;
                            accumulator.add(b);
                        } else {
                            String stringValue = value.toString();
                            accumulator.add(this.parseBoolean(stringValue));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                protected void parseNonNullValue(XContentParser parser, List<Boolean> accumulator) throws IOException {
                    try {
                        boolean value = parser.booleanValue();
                        accumulator.add(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void writeToBlock(List<Boolean> values, BlockLoader.Builder blockBuilder) {
                    BlockLoader.BooleanBuilder booleanBuilder = (BlockLoader.BooleanBuilder)blockBuilder;
                    for (Boolean value : values) {
                        booleanBuilder.appendBoolean(value);
                    }
                }
            };
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN, BooleanDocValuesField::new, this.indexType);
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedBooleanIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BOOLEAN, (ValueFetcher)this.sourceValueFetcher(sourcePaths, fieldDataContext.indexSettings()), (SourceProvider)searchLookup, BooleanDocValuesField::new);
            }
            throw new IllegalStateException("unknown field data type [" + operation.name() + "]");
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.termQuery(value, context);
            }
            return SortedNumericDocValuesField.newSlowExactQuery((String)this.name(), (long)this.docValueForSearch(value));
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.termsQuery(values, context);
            }
            HashSet dedupe = new HashSet(values);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Object value : dedupe) {
                builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
            }
            return new ConstantScoreQuery((Query)builder.build());
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
            }
            long l = 0L;
            long u = 1L;
            if (lowerTerm != null) {
                l = this.docValueForSearch(lowerTerm);
                if (!includeLower) {
                    l = Math.max(1L, l + 1L);
                }
            }
            if (upperTerm != null) {
                u = this.docValueForSearch(upperTerm);
                if (!includeUpper) {
                    l = Math.min(0L, l - 1L);
                }
            }
            if (l > u) {
                return new MatchNoDocsQuery();
            }
            return SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef((CharSequence)"T");
        public static final BytesRef FALSE = new BytesRef((CharSequence)"F");
    }
}

