/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.util.Locale;
import org.elasticsearch.common.breaker.CircuitBreakingException;

public interface CircuitBreaker {
    public static final String PARENT = "parent";
    public static final String FIELDDATA = "fielddata";
    public static final String REQUEST = "request";
    public static final String IN_FLIGHT_REQUESTS = "inflight_requests";

    public void circuitBreak(String var1, long var2);

    public void addEstimateBytesAndMaybeBreak(long var1, String var3) throws CircuitBreakingException;

    public void addWithoutBreaking(long var1);

    public long getUsed();

    public long getLimit();

    public double getOverhead();

    public long getTrippedCount();

    public String getName();

    public Durability getDurability();

    public void setLimitAndOverhead(long var1, double var3);

    public static enum Durability {
        TRANSIENT,
        PERMANENT;

    }

    public static enum Type {
        MEMORY,
        PARENT,
        NOOP;


        public static Type parseValue(String value) {
            return switch (value.toLowerCase(Locale.ROOT)) {
                case "noop" -> NOOP;
                case CircuitBreaker.PARENT -> PARENT;
                case "memory" -> MEMORY;
                default -> throw new IllegalArgumentException("No CircuitBreaker with type: " + value);
            };
        }
    }
}

