/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexReshardingMetadata;
import org.elasticsearch.cluster.metadata.IndexReshardingState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.SearchShardRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.ResponseCollectorService;

public class OperationRouting {
    public static final Setting<Boolean> USE_ADAPTIVE_REPLICA_SELECTION_SETTING = Setting.boolSetting("cluster.routing.use_adaptive_replica_selection", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private boolean useAdaptiveReplicaSelection;

    public OperationRouting(Settings settings, ClusterSettings clusterSettings) {
        this.useAdaptiveReplicaSelection = USE_ADAPTIVE_REPLICA_SELECTION_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, this::setUseAdaptiveReplicaSelection);
    }

    void setUseAdaptiveReplicaSelection(boolean useAdaptiveReplicaSelection) {
        this.useAdaptiveReplicaSelection = useAdaptiveReplicaSelection;
    }

    public ShardIterator getShards(ProjectState projectState, String index, String id, @Nullable String routing, @Nullable String preference) {
        IndexRouting indexRouting = IndexRouting.fromIndexMetadata(OperationRouting.indexMetadata(projectState.metadata(), index));
        IndexShardRoutingTable shards = projectState.routingTable().shardRoutingTable(index, indexRouting.getShard(id, routing));
        DiscoveryNodes nodes = projectState.cluster().nodes();
        return this.preferenceActiveShardIterator(shards, nodes.getLocalNodeId(), nodes, preference, null, null);
    }

    public ShardIterator getShards(ProjectState projectState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = projectState.routingTable().shardRoutingTable(index, shardId);
        DiscoveryNodes nodes = projectState.cluster().nodes();
        return this.preferenceActiveShardIterator(indexShard, nodes.getLocalNodeId(), nodes, preference, null, null);
    }

    public List<SearchShardRouting> searchShards(ProjectState projectState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        return this.searchShards(projectState, concreteIndices, routing, preference, null, null);
    }

    public List<SearchShardRouting> searchShards(ProjectState projectState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        Set<SearchTargetShard> shards = OperationRouting.computeTargetedShards(projectState, concreteIndices, routing);
        DiscoveryNodes nodes = projectState.cluster().nodes();
        ArrayList<SearchShardRouting> res = new ArrayList<SearchShardRouting>(shards.size());
        for (SearchTargetShard targetShard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(targetShard.shardRoutingTable(), nodes.getLocalNodeId(), nodes, preference, collectorService, nodeCounts);
            if (iterator == null) continue;
            res.add(SearchShardRouting.fromShardIterator(ShardIterator.allSearchableShards(iterator), targetShard.reshardSplitShardCountSummary()));
        }
        res.sort(ShardIterator::compareTo);
        return res;
    }

    public Iterator<IndexShardRoutingTable> allWritableShards(ProjectState projectState, String index) {
        return OperationRouting.allWriteAddressableShards(projectState, index);
    }

    public static ShardIterator getShards(RoutingTable routingTable, ShardId shardId) {
        IndexShardRoutingTable shard = routingTable.shardRoutingTable(shardId);
        return shard.activeInitializingShardsRandomIt();
    }

    private static Set<SearchTargetShard> computeTargetedShards(ProjectState projectState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        if (routing == null || routing.isEmpty()) {
            return OperationRouting.collectTargetShardsNoRouting(projectState, concreteIndices);
        }
        return OperationRouting.collectTargetShardsWithRouting(projectState, concreteIndices, routing);
    }

    private static Set<SearchTargetShard> collectTargetShardsWithRouting(ProjectState projectState, String[] concreteIndices, Map<String, Set<String>> routing) {
        HashSet<SearchTargetShard> result = new HashSet<SearchTargetShard>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = OperationRouting.indexRoutingTable(projectState.routingTable(), index);
            Set<String> indexSearchRouting = routing.get(index);
            if (indexSearchRouting != null) {
                IndexMetadata indexMetadata = OperationRouting.indexMetadata(projectState.metadata(), index);
                IndexRouting indexRouting = IndexRouting.fromIndexMetadata(indexMetadata);
                for (String r : indexSearchRouting) {
                    indexRouting.collectSearchShards(r, shardId -> result.add(new SearchTargetShard(RoutingTable.shardRoutingTable(indexRoutingTable, shardId), SplitShardCountSummary.forSearch(indexMetadata, shardId))));
                }
                continue;
            }
            Iterator<SearchTargetShard> iterator = OperationRouting.allSearchAddressableShards(projectState, index);
            iterator.forEachRemaining(result::add);
        }
        return result;
    }

    private static Set<SearchTargetShard> collectTargetShardsNoRouting(ProjectState projectState, String[] concreteIndices) {
        HashSet<SearchTargetShard> result = new HashSet<SearchTargetShard>();
        for (String index : concreteIndices) {
            Iterator<SearchTargetShard> iterator = OperationRouting.allSearchAddressableShards(projectState, index);
            iterator.forEachRemaining(result::add);
        }
        return result;
    }

    private static Iterator<SearchTargetShard> allSearchAddressableShards(ProjectState projectState, String index) {
        IndexRoutingTable indexRoutingTable = OperationRouting.indexRoutingTable(projectState.routingTable(), index);
        IndexMetadata indexMetadata = OperationRouting.indexMetadata(projectState.metadata(), index);
        if (indexMetadata.getReshardingMetadata() == null) {
            return indexRoutingTable.allShards().map(srt -> new SearchTargetShard((IndexShardRoutingTable)srt, SplitShardCountSummary.forSearch(indexMetadata, srt.shardId.id()))).iterator();
        }
        IndexReshardingMetadata indexReshardingMetadata = indexMetadata.getReshardingMetadata();
        assert (indexReshardingMetadata.isSplit());
        IndexReshardingState.Split splitState = indexReshardingMetadata.getSplit();
        ArrayList<SearchTargetShard> shards = new ArrayList<SearchTargetShard>();
        for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
            if (splitState.isTargetShard(shardId) && !splitState.targetStateAtLeast(shardId, IndexReshardingState.Split.TargetShardState.SPLIT)) continue;
            shards.add(new SearchTargetShard(indexRoutingTable.shard(shardId), SplitShardCountSummary.forSearch(indexMetadata, shardId)));
        }
        return shards.iterator();
    }

    private static Iterator<IndexShardRoutingTable> allWriteAddressableShards(ProjectState projectState, String index) {
        IndexRoutingTable indexRoutingTable = OperationRouting.indexRoutingTable(projectState.routingTable(), index);
        IndexMetadata indexMetadata = OperationRouting.indexMetadata(projectState.metadata(), index);
        if (indexMetadata.getReshardingMetadata() == null) {
            return indexRoutingTable.allShards().iterator();
        }
        IndexReshardingMetadata indexReshardingMetadata = indexMetadata.getReshardingMetadata();
        assert (indexReshardingMetadata.isSplit());
        IndexReshardingState.Split splitState = indexReshardingMetadata.getSplit();
        ArrayList<IndexShardRoutingTable> shards = new ArrayList<IndexShardRoutingTable>();
        for (int i = 0; i < indexRoutingTable.size(); ++i) {
            if (splitState.isTargetShard(i) && !splitState.targetStateAtLeast(i, IndexReshardingState.Split.TargetShardState.HANDOFF)) continue;
            shards.add(indexRoutingTable.shard(i));
        }
        return shards.iterator();
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (preference == null || preference.isEmpty()) {
            return this.shardRoutings(indexShard, collectorService, nodeCounts);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(124);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    return this.shardRoutings(indexShard, collectorService, nodeCounts);
                }
                preference = preference.substring(index + 1);
            }
            if (preference.charAt(0) == '_') {
                preferenceType = Preference.parse(preference);
                switch (preferenceType) {
                    case PREFER_NODES: {
                        Set<String> nodesIds = Arrays.stream(preference.substring(Preference.PREFER_NODES.type().length() + 1).split(",")).collect(Collectors.toSet());
                        return indexShard.preferNodeActiveInitializingShardsIt(nodesIds);
                    }
                    case LOCAL: {
                        return indexShard.preferNodeActiveInitializingShardsIt(Collections.singleton(localNodeId));
                    }
                    case ONLY_LOCAL: {
                        return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                    }
                    case ONLY_NODES: {
                        String nodeAttributes = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                        return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttributes.split(","), nodes);
                    }
                }
                throw new IllegalArgumentException("unknown preference [" + String.valueOf((Object)preferenceType) + "]");
            }
        }
        int routingHash = 31 * Murmur3HashFunction.hash(preference) + indexShard.shardId.hashCode();
        return indexShard.activeInitializingShardsIt(routingHash);
    }

    private ShardIterator shardRoutings(IndexShardRoutingTable indexShard, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (this.useAdaptiveReplicaSelection) {
            return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
        }
        return indexShard.activeInitializingShardsRandomIt();
    }

    protected static IndexRoutingTable indexRoutingTable(RoutingTable routingTable, String index) {
        IndexRoutingTable indexRouting = routingTable.index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    private static IndexMetadata indexMetadata(ProjectMetadata project, String index) {
        IndexMetadata indexMetadata = project.index(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        return indexMetadata;
    }

    public static ShardId shardId(ProjectMetadata projectMetadata, String index, String id, @Nullable String routing) {
        IndexMetadata indexMetadata = OperationRouting.indexMetadata(projectMetadata, index);
        return new ShardId(indexMetadata.getIndex(), IndexRouting.fromIndexMetadata(indexMetadata).getShard(id, routing));
    }

    private record SearchTargetShard(IndexShardRoutingTable shardRoutingTable, SplitShardCountSummary reshardSplitShardCountSummary) {
    }
}

