/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginRuntimeInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PluginsAndModules
implements ReportingService.Info {
    private final List<PluginRuntimeInfo> plugins;
    private final List<PluginDescriptor> modules;

    public PluginsAndModules(List<PluginRuntimeInfo> plugins, List<PluginDescriptor> modules) {
        this.plugins = Collections.unmodifiableList(plugins);
        this.modules = Collections.unmodifiableList(modules);
    }

    public PluginsAndModules(StreamInput in) throws IOException {
        this.plugins = in.readCollectionAsImmutableList(PluginRuntimeInfo::new);
        this.modules = in.readCollectionAsImmutableList(PluginDescriptor::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.plugins);
        out.writeCollection(this.modules);
    }

    public List<PluginRuntimeInfo> getPluginInfos() {
        return this.plugins.stream().sorted(Comparator.comparing(p -> p.descriptor().getName())).toList();
    }

    public List<PluginDescriptor> getModuleInfos() {
        ArrayList<PluginDescriptor> modules = new ArrayList<PluginDescriptor>(this.modules);
        Collections.sort(modules, Comparator.comparing(PluginDescriptor::getName));
        return modules;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("plugins");
        for (PluginRuntimeInfo pluginInfo : this.plugins) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("modules");
        for (PluginDescriptor moduleInfo : this.getModuleInfos()) {
            moduleInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

